/*
 * Decompiled with CFR 0.152.
 */
package tictim.paraglider.client.settings;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import it.unimi.dsi.fastutil.booleans.BooleanConsumer;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import net.minecraft.Util;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.NbtOps;
import net.neoforged.fml.loading.FMLPaths;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tictim.paraglider.ParagliderClientMod;
import tictim.paraglider.ParagliderMod;
import tictim.paraglider.client.settings.ParagliderClientSettings;

public class ParagliderClientSettingsIO {
    public static final Path FILEPATH = FMLPaths.GAMEDIR.get().resolve("paragliderSettings.nbt");

    public static void save(@NotNull ParagliderClientSettings settings, @Nullable BooleanConsumer callback) {
        Util.ioPool().execute(() -> {
            boolean result = ParagliderClientSettingsIO.saveInternal(settings);
            if (callback != null) {
                callback.accept(result);
            }
        });
    }

    private static boolean saveInternal(@NotNull ParagliderClientSettings settings) {
        DataResult result = ParagliderClientSettings.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)settings);
        return (Boolean)result.mapOrElse(t -> {
            Boolean bl;
            if (!(t instanceof CompoundTag)) {
                ParagliderMod.LOGGER.error("Error occurred while saving paraglider settings: Expected compound tag");
                return false;
            }
            CompoundTag compoundTag = (CompoundTag)t;
            DataOutputStream dos = new DataOutputStream(Files.newOutputStream(FILEPATH, StandardOpenOption.CREATE));
            try {
                NbtIo.write((CompoundTag)compoundTag, (DataOutput)dos);
                bl = true;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        dos.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException | RuntimeException ex) {
                    ParagliderMod.LOGGER.error("Error occurred while saving paraglider settings: ", (Throwable)ex);
                    return false;
                }
            }
            dos.close();
            return bl;
        }, e -> {
            ParagliderMod.LOGGER.error("Error occurred while saving paraglider settings: {}", (Object)e.message());
            return false;
        });
    }

    public static void load(@Nullable BooleanConsumer callback) {
        Util.ioPool().execute(() -> {
            Pair<Boolean, @Nullable ParagliderClientSettings> pair = ParagliderClientSettingsIO.loadInternal();
            if (callback != null) {
                callback.accept(((Boolean)pair.getFirst()).booleanValue());
            }
            ParagliderClientMod.instance().setSettings((ParagliderClientSettings)pair.getSecond());
        });
    }

    private static Pair<Boolean, @Nullable ParagliderClientSettings> loadInternal() {
        block8: {
            Pair pair;
            DataInputStream dis2 = new DataInputStream(Files.newInputStream(FILEPATH, new OpenOption[0]));
            try {
                DataResult result = ParagliderClientSettings.CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)NbtIo.read((DataInput)dis2));
                pair = (Pair)result.mapOrElse(s -> Pair.of((Object)true, (Object)s), e -> {
                    ParagliderMod.LOGGER.error("Error occurred while loading paraglider settings: {}", (Object)e.message());
                    return Pair.of((Object)false, (Object)e.partialValue().orElse(null));
                });
            }
            catch (Throwable throwable) {
                try {
                    try {
                        dis2.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (NoSuchFileException dis2) {
                    break block8;
                }
                catch (IOException | RuntimeException ex) {
                    ParagliderMod.LOGGER.error("Error occurred while loading paraglider settings: ", (Throwable)ex);
                }
            }
            dis2.close();
            return pair;
        }
        return Pair.of((Object)false, null);
    }
}

