/*
 * Decompiled with CFR 0.152.
 */
package tictim.paraglider.config;

import it.unimi.dsi.fastutil.objects.Object2ObjectAVLTreeMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.common.ModConfigSpec;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tictim.paraglider.ParagliderMod;
import tictim.paraglider.api.movement.ParagliderPlayerStates;
import tictim.paraglider.api.movement.PlayerState;
import tictim.paraglider.config.Cfg;
import tictim.paraglider.impl.movement.PlayerStateMap;
import tictim.paraglider.impl.movement.SimplePlayerState;

public class PlayerStateMapConfig {
    public static final String FILENAME = "paraglider-player-states.toml";
    public final ModConfigSpec spec;
    private final PlayerStateMap originalStateMap;
    private final Map<ResourceLocation, Config> configSpecs;
    private final List<@NotNull Consumer<@NotNull PlayerStateMap>> onUpdateCallbacks = new ArrayList<Consumer<PlayerStateMap>>();
    @Nullable
    private PlayerStateMap configuredStateMap;

    public PlayerStateMapConfig(@NotNull PlayerStateMap originalStateMap) {
        this.originalStateMap = originalStateMap;
        Object2ObjectAVLTreeMap states = new Object2ObjectAVLTreeMap((o1, o2) -> {
            if (o1.equals(o2)) {
                return 0;
            }
            if ("paraglider".equals(o1)) {
                return -1;
            }
            if ("paraglider".equals(o2)) {
                return 1;
            }
            return o1.compareTo((String)o2);
        });
        for (Map.Entry<ResourceLocation, PlayerState> e : originalStateMap.states().entrySet()) {
            states.computeIfAbsent(e.getKey().getNamespace(), s -> new Object2ObjectAVLTreeMap()).put(e.getKey().getPath(), e.getValue());
        }
        ModConfigSpec.Builder b = new ModConfigSpec.Builder();
        this.configSpecs = new Object2ObjectOpenHashMap();
        for (Map.Entry e : states.entrySet()) {
            if (((String)e.getKey()).equals("paraglider")) {
                b.comment("Configuration file for player states.\nYou can adjust stamina delta (negative value means consumption / positive value means gain) and\nrecovery delay (in ticks) of all player states registered in the game.\nTo reload the config, use the following command: /paraglider reloadPlayerStates\n");
            }
            b.push((String)e.getKey());
            for (Map.Entry e2 : ((Map)e.getValue()).entrySet()) {
                b.push((String)e2.getKey());
                PlayerState state = (PlayerState)e2.getValue();
                ModConfigSpec.DoubleValue staminaDelta = b.defineInRange("staminaDelta", state.staminaDelta(), Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
                ModConfigSpec.IntValue recoveryDelay = b.defineInRange("recoveryDelay", state.recoveryDelay(), 0, Integer.MAX_VALUE);
                this.configSpecs.put(state.id(), new Config(staminaDelta, recoveryDelay));
                b.pop();
            }
            b.pop();
        }
        this.spec = b.build();
    }

    @NotNull
    public PlayerStateMap stateMap() {
        return this.configuredStateMap != null ? this.configuredStateMap : this.originalStateMap;
    }

    @NotNull
    public PlayerStateMap originalStateMap() {
        return this.originalStateMap;
    }

    @Nullable
    public PlayerStateMap configuredStateMap() {
        return this.configuredStateMap;
    }

    public void addCallback(@NotNull @NotNull Consumer<@NotNull PlayerStateMap> callback) {
        this.onUpdateCallbacks.add(Objects.requireNonNull(callback, "callback == null"));
    }

    public void removeCallbacks() {
        this.onUpdateCallbacks.clear();
    }

    public void reload(@Nullable Callback callback) {
        this.reload(Runnable::run, callback);
    }

    public void reload(@NotNull @NotNull Consumer<@NotNull Runnable> onUpdatedCallbackDispatcher, @Nullable Callback callback) {
        boolean contentUpdated;
        PlayerStateMap prevStateMap = this.stateMap();
        RuntimeException exception = null;
        try {
            this.reloadInternal();
        }
        catch (RuntimeException ex) {
            this.configuredStateMap = null;
            ParagliderMod.LOGGER.error("Cannot load state map due to an error", (Throwable)ex);
            exception = ex;
        }
        PlayerStateMap stateMap = this.stateMap();
        boolean bl = contentUpdated = !PlayerStateMap.isSame(prevStateMap, stateMap);
        if (contentUpdated) {
            for (Consumer<PlayerStateMap> onUpdate : this.onUpdateCallbacks) {
                onUpdatedCallbackDispatcher.accept(() -> onUpdate.accept(stateMap));
            }
        }
        if (callback != null) {
            if (exception == null) {
                onUpdatedCallbackDispatcher.accept(() -> callback.onSuccess(stateMap, contentUpdated));
            } else {
                RuntimeException finalException = exception;
                onUpdatedCallbackDispatcher.accept(() -> callback.onFail(stateMap, finalException, contentUpdated));
            }
        }
    }

    protected void reloadInternal() {
        boolean paraglidingConsumesStamina = Cfg.get().paraglidingConsumesStamina();
        boolean runningConsumesStamina = Cfg.get().runningConsumesStamina();
        @Nullable Object2ObjectOpenHashMap newStates = null;
        for (Map.Entry<ResourceLocation, PlayerState> e : this.originalStateMap.states().entrySet()) {
            ResourceLocation id = e.getKey();
            PlayerState state = e.getValue();
            Config config = this.configSpecs.get(id);
            double staminaDelta = (Double)config.staminaDelta.get();
            int recoveryDelay = (Integer)config.recoveryDelay.get();
            if (Double.isNaN(staminaDelta)) {
                staminaDelta = 0.0;
            }
            if (state.hasFlag(ParagliderPlayerStates.Flags.DISABLED_BY_RUNNING_CONFIG) && staminaDelta < 0.0 && !runningConsumesStamina) {
                staminaDelta = 0.0;
            }
            if (state.hasFlag(ParagliderPlayerStates.Flags.DISABLED_BY_PARAGLIDING_CONFIG) && staminaDelta < 0.0 && !paraglidingConsumesStamina) {
                staminaDelta = 0.0;
            }
            if (staminaDelta > 0.0 && recoveryDelay > 0) {
                ParagliderMod.LOGGER.warn("Player state {} has both positive stamina delta ({}) and recovery delay ({}). Setting recovery value to 0.", (Object)id, (Object)staminaDelta, (Object)recoveryDelay);
                recoveryDelay = 0;
            }
            if (state.staminaDelta() == staminaDelta && state.recoveryDelay() == recoveryDelay) continue;
            if (newStates == null) {
                newStates = new Object2ObjectOpenHashMap(this.originalStateMap.states());
            }
            newStates.put(id, new SimplePlayerState(state, staminaDelta, recoveryDelay));
        }
        this.configuredStateMap = newStates == null ? null : new PlayerStateMap((Map<ResourceLocation, PlayerState>)newStates);
    }

    protected record Config(@NotNull ModConfigSpec.DoubleValue staminaDelta, @NotNull ModConfigSpec.IntValue recoveryDelay) {
    }

    public static interface Callback {
        public void onSuccess(@NotNull PlayerStateMap var1, boolean var2);

        public void onFail(@NotNull PlayerStateMap var1, @NotNull RuntimeException var2, boolean var3);
    }
}

