/*
 * Decompiled with CFR 0.152.
 */
package tictim.paraglider.config;

import net.neoforged.neoforge.common.ModConfigSpec;
import org.jetbrains.annotations.NotNull;
import tictim.paraglider.config.Cfg;

public class ServerConfig
implements Cfg {
    public final ModConfigSpec spec;
    private final ModConfigSpec.BooleanValue updraft;
    private final ModConfigSpec.DoubleValue paraglidingSpeed;
    private final ModConfigSpec.IntValue paragliderDurability;
    private final ModConfigSpec.BooleanValue enderDragonDropsVessel;
    private final ModConfigSpec.BooleanValue witherDropsVessel;
    private final ModConfigSpec.BooleanValue raidGivesVessel;
    private final ModConfigSpec.BooleanValue elderGuardianDropsSpiritOrb;
    private final ModConfigSpec.DoubleValue spawnerSpiritOrbDrops;
    private final ModConfigSpec.DoubleValue trialSpiritOrbDrops;
    private final ModConfigSpec.DoubleValue ominousTrialSpiritOrbDrops;
    private final ModConfigSpec.BooleanValue spiritOrbLoots;
    private final ModConfigSpec.IntValue startingHearts;
    private final ModConfigSpec.IntValue maxHeartContainers;
    private final ModConfigSpec.IntValue startingStamina;
    private final ModConfigSpec.IntValue maxStaminaVessels;
    private final ModConfigSpec.IntValue staminaIncreasePerVessel;
    private final ModConfigSpec.BooleanValue paraglidingConsumesStamina;
    private final ModConfigSpec.BooleanValue runningConsumesStamina;
    private final ModConfigSpec.EnumValue<Cfg.TotwCompatConfigOption> paragliderInTowersOfTheWild;

    public ServerConfig() {
        ModConfigSpec.Builder b = new ModConfigSpec.Builder();
        this.updraft = b.comment("If true, wind sources will generate updrafts that interact with Paraglider.\nWind sources and strength (i.e. height) of the updraft created can be adjusted with datapacks.\nSee online docs for more information: (work in progress)").define("updraft", true);
        this.paraglidingSpeed = b.comment("Multiplier to horizontal movement speed while paragliding.\nValue of 0.5 means 50% of the speed, 2.0 means two times the speed and so forth.").defineInRange("paraglidingSpeed", 1.0, 0.2, 10.0);
        this.paragliderDurability = b.comment("Durability of Paragliders. Set to zero to disable durability.").defineInRange("paragliderDurability", 0, 0, Integer.MAX_VALUE);
        b.push("spiritOrbs");
        this.enderDragonDropsVessel = b.comment("If true, Ender Dragon will drop heart container(stamina vessel if heart container is disabled) upon death.").define("enderDragonDropsVessel", true);
        this.witherDropsVessel = b.comment("If true, Wither will drop heart container(stamina vessel if heart container is disabled) upon death.").define("enderDragonDropsVessel", true);
        this.raidGivesVessel = b.comment("If true, Raids will give heart container(stamina vessel if heart container is disabled) upon victory.").define("raidGivesVessel", true);
        this.elderGuardianDropsSpiritOrb = b.comment("If true, Elder Guardian will drop a Spirit Orb upon death.").define("raidGivesVessel", true);
        this.spawnerSpiritOrbDrops = b.comment("Amount of Spirit Orbs dropped from spawners. Fractional values are treated as a chanced drop, in addition to whole values which is guaranteed to drop.").defineInRange("spawnerSpiritOrbDrops", 1.0, 0.0, 64.0);
        this.trialSpiritOrbDrops = b.comment("Amount of Spirit Orbs dropped from completing trial. Fractional values are treated as a chanced drop, in addition to whole values which is guaranteed to drop.").defineInRange("trialSpiritOrbDrops", 2.0, 0.0, 64.0);
        this.ominousTrialSpiritOrbDrops = b.comment("Amount of Spirit Orbs dropped from completing ominous trial. Fractional values are treated as a chanced drop, in addition to whole values which is guaranteed to drop.").defineInRange("ominousTrialSpiritOrbDrops", 4.0, 0.0, 64.0);
        this.spiritOrbLoots = b.comment("If true, various types of chest will have chances of having Spirit Orbs inside.\nDoes not change contents of already generated chests.").define("spiritOrbLoots", true);
        b.pop();
        b.push("vessels");
        this.startingHearts = b.comment("Starting health points measured in number of hearts.").defineInRange("startingHearts", 10, 1, 512);
        this.maxHeartContainers = b.comment("Maximum amount of Heart Containers one player can consume.\nDo note that the maximum health point is capped at value of 1024 (or 512 hearts) by Minecraft's default\nattribute system; without modifying these limits, Heart Containers won't give you extra hearts beyond that.").defineInRange("maxHeartContainers", 20, 0, 512);
        this.startingStamina = b.comment("Amount of stamina players start with. One full stamina wheel is equivalent to 1000 stamina.").defineInRange("startingStamina", 1000, 0, Integer.MAX_VALUE);
        this.maxStaminaVessels = b.comment("Maximum amount of Stamina Vessels one player can consume. Higher value = higher maximum stamina.").defineInRange("maxStaminaVessels", 10, 0, Integer.MAX_VALUE);
        this.staminaIncreasePerVessel = b.comment("Stamina increase per vessel. One full stamina wheel is equivalent to 1000 stamina.").defineInRange("staminaIncreasePerVessel", 200, 0, Integer.MAX_VALUE);
        b.pop();
        b.push("stamina");
        this.paraglidingConsumesStamina = b.comment("Paragliding will consume stamina. Run /paraglider reloadPlayerStates after change.").define("paraglidingConsumesStamina", true);
        this.runningConsumesStamina = b.comment("Certain non-paragliding actions, such as running and swimming, will consume stamina. Run /paraglider reloadPlayerStates after change.").define("runningAndSwimmingConsumesStamina", false);
        b.pop();
        this.paragliderInTowersOfTheWild = b.comment("Configurable option for Towers of the Wild compat feature. Can be ignored if Towers of the Wild is not installed.\nDEFAULT: Default option, spawn Deku Leaf in ocean tower chests and Paraglider in normal tower chests\nDISABLE: Don't spawn anything\nPARAGLIDER_ONLY: Spawn paraglider in both ocean and normal tower chests\nDEKU_LEAF_ONLY: Spawn deku leaf in both ocean and normal tower chests, like a boss").defineEnum("paragliderInTowersOfTheWild", (Enum)Cfg.TotwCompatConfigOption.DEFAULT);
        this.spec = b.build();
    }

    @Override
    public boolean updraft() {
        return (Boolean)ServerConfig.get(this.spec, this.updraft);
    }

    @Override
    public double paraglidingSpeed() {
        return (Double)ServerConfig.get(this.spec, this.paraglidingSpeed);
    }

    @Override
    public int paragliderDurability() {
        return (Integer)ServerConfig.get(this.spec, this.paragliderDurability);
    }

    @Override
    public boolean enderDragonDropsVessel() {
        return (Boolean)ServerConfig.get(this.spec, this.enderDragonDropsVessel);
    }

    @Override
    public boolean witherDropsVessel() {
        return (Boolean)ServerConfig.get(this.spec, this.witherDropsVessel);
    }

    @Override
    public boolean raidGivesVessel() {
        return (Boolean)ServerConfig.get(this.spec, this.raidGivesVessel);
    }

    @Override
    public boolean elderGuardianDropsSpiritOrb() {
        return (Boolean)ServerConfig.get(this.spec, this.elderGuardianDropsSpiritOrb);
    }

    @Override
    public double spawnerSpiritOrbDrops() {
        return (Double)ServerConfig.get(this.spec, this.spawnerSpiritOrbDrops);
    }

    @Override
    public double trialSpiritOrbDrops() {
        return (Double)ServerConfig.get(this.spec, this.trialSpiritOrbDrops);
    }

    @Override
    public double ominousTrialSpiritOrbDrops() {
        return (Double)ServerConfig.get(this.spec, this.ominousTrialSpiritOrbDrops);
    }

    @Override
    public boolean spiritOrbLoots() {
        return (Boolean)ServerConfig.get(this.spec, this.spiritOrbLoots);
    }

    @Override
    public int startingHearts() {
        return (Integer)ServerConfig.get(this.spec, this.startingHearts);
    }

    @Override
    public int maxHeartContainers() {
        return (Integer)ServerConfig.get(this.spec, this.maxHeartContainers);
    }

    @Override
    public int startingStamina() {
        return (Integer)ServerConfig.get(this.spec, this.startingStamina);
    }

    @Override
    public int maxStaminaVessels() {
        return (Integer)ServerConfig.get(this.spec, this.maxStaminaVessels);
    }

    @Override
    public int staminaIncreasePerVessel() {
        return (Integer)ServerConfig.get(this.spec, this.staminaIncreasePerVessel);
    }

    @Override
    public boolean paraglidingConsumesStamina() {
        return (Boolean)ServerConfig.get(this.spec, this.paraglidingConsumesStamina);
    }

    @Override
    public boolean runningConsumesStamina() {
        return (Boolean)ServerConfig.get(this.spec, this.runningConsumesStamina);
    }

    @Override
    @NotNull
    public Cfg.TotwCompatConfigOption paragliderInTowersOfTheWild() {
        return ServerConfig.get(this.spec, this.paragliderInTowersOfTheWild);
    }

    @NotNull
    private static <T> T get(@NotNull ModConfigSpec spec, @NotNull ModConfigSpec.ConfigValue<T> val) {
        return (T)(spec.isLoaded() ? val.get() : val.getDefault());
    }
}

