/*
 * Decompiled with CFR 0.152.
 */
package tictim.paraglider.contents;

import com.mojang.serialization.MapCodec;
import java.util.Locale;
import net.neoforged.neoforge.common.conditions.ICondition;
import net.neoforged.neoforge.registries.DeferredRegister;
import org.jetbrains.annotations.NotNull;
import tictim.paraglider.config.FeatureCfg;

public enum ParagliderConfigCondition implements ICondition
{
    HEART_CONTAINER_ENABLED,
    STAMINA_VESSEL_ENABLED;

    private final MapCodec<ParagliderConfigCondition> codec = MapCodec.unit((Object)((Object)this));

    @NotNull
    public MapCodec<? extends ICondition> codec() {
        return this.codec;
    }

    public boolean test(@NotNull ICondition.IContext context) {
        return switch (this.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> FeatureCfg.get().enableHeartContainers();
            case 1 -> FeatureCfg.get().enableStaminaVessels();
        };
    }

    public static void register(DeferredRegister<MapCodec<? extends ICondition>> register) {
        for (ParagliderConfigCondition c : ParagliderConfigCondition.values()) {
            MapCodec<ParagliderConfigCondition> type = c.codec;
            register.register(c.name().toLowerCase(Locale.ROOT), () -> type);
        }
    }
}

