/*
 * Decompiled with CFR 0.152.
 */
package tictim.paraglider.contents.block;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import tictim.paraglider.api.bargain.ParagliderBargainTypes;
import tictim.paraglider.bargain.BargainHandler;
import tictim.paraglider.contents.ParagliderAdvancements;
import tictim.paraglider.contents.block.BaseStatueBlock;

public class HornedStatueBlock
extends BaseStatueBlock {
    public static final MapCodec<HornedStatueBlock> CODEC = HornedStatueBlock.simpleCodec(HornedStatueBlock::new);
    private static final VoxelShape SHAPE_NORTH = Shapes.or((VoxelShape)HornedStatueBlock.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)14.0, (double)12.0), (VoxelShape[])new VoxelShape[]{HornedStatueBlock.box((double)5.0, (double)0.0, (double)2.0, (double)11.0, (double)12.0, (double)3.0), HornedStatueBlock.box((double)3.0, (double)0.0, (double)12.0, (double)13.0, (double)13.0, (double)13.0)}).optimize();
    private static final VoxelShape SHAPE_EAST = Shapes.or((VoxelShape)HornedStatueBlock.box((double)4.0, (double)0.0, (double)3.0, (double)13.0, (double)14.0, (double)13.0), (VoxelShape[])new VoxelShape[]{HornedStatueBlock.box((double)13.0, (double)0.0, (double)5.0, (double)14.0, (double)12.0, (double)11.0), HornedStatueBlock.box((double)3.0, (double)0.0, (double)3.0, (double)4.0, (double)13.0, (double)13.0)}).optimize();
    private static final VoxelShape SHAPE_SOUTH = Shapes.or((VoxelShape)HornedStatueBlock.box((double)3.0, (double)0.0, (double)4.0, (double)13.0, (double)14.0, (double)13.0), (VoxelShape[])new VoxelShape[]{HornedStatueBlock.box((double)5.0, (double)0.0, (double)13.0, (double)11.0, (double)12.0, (double)14.0), HornedStatueBlock.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)13.0, (double)4.0)}).optimize();
    private static final VoxelShape SHAPE_WEST = Shapes.or((VoxelShape)HornedStatueBlock.box((double)3.0, (double)0.0, (double)3.0, (double)12.0, (double)14.0, (double)13.0), (VoxelShape[])new VoxelShape[]{HornedStatueBlock.box((double)2.0, (double)0.0, (double)5.0, (double)3.0, (double)12.0, (double)11.0), HornedStatueBlock.box((double)12.0, (double)0.0, (double)3.0, (double)13.0, (double)13.0, (double)13.0)}).optimize();

    public HornedStatueBlock(@NotNull BlockBehaviour.Properties properties) {
        super(properties);
    }

    @NotNull
    protected MapCodec<? extends HorizontalDirectionalBlock> codec() {
        return CODEC;
    }

    @NotNull
    public VoxelShape getShape(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return switch ((Direction)state.getValue((Property)FACING)) {
            case Direction.EAST -> SHAPE_EAST;
            case Direction.SOUTH -> SHAPE_SOUTH;
            case Direction.WEST -> SHAPE_WEST;
            default -> SHAPE_NORTH;
        };
    }

    @NotNull
    protected InteractionResult useWithoutItem(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull BlockHitResult hit) {
        if (!level.isClientSide) {
            BargainHandler.initiate(player, ParagliderBargainTypes.HORNED_STATUE, pos, ParagliderAdvancements.STATUES_BARGAIN, new Vec3((double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5));
        }
        return InteractionResult.SUCCESS;
    }
}

