/*
 * Decompiled with CFR 0.152.
 */
package tictim.paraglider.contents.item;

import java.text.DecimalFormat;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import org.jetbrains.annotations.NotNull;
import tictim.paraglider.api.stamina.Stamina;
import tictim.paraglider.contents.Contents;

public abstract class BaseElixirItem
extends Item {
    private static final DecimalFormat D0 = new DecimalFormat("0.#");
    private static final DecimalFormat PCT = new DecimalFormat("+0%");

    public BaseElixirItem(Item.Properties properties) {
        super(properties);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level level, Player player, @NotNull InteractionHand usedHand) {
        player.startUsingItem(usedHand);
        return InteractionResultHolder.consume((Object)player.getItemInHand(usedHand));
    }

    @NotNull
    public UseAnim getUseAnimation(@NotNull ItemStack stack) {
        return UseAnim.DRINK;
    }

    public int getUseDuration(@NotNull ItemStack stack, @NotNull LivingEntity entity) {
        return 12;
    }

    @NotNull
    public ItemStack finishUsingItem(@NotNull ItemStack stack, @NotNull Level level, @NotNull LivingEntity livingEntity) {
        if (livingEntity instanceof Player) {
            Player p = (Player)livingEntity;
            this.applyEffect(p);
            p.awardStat(Stats.ITEM_USED.get((Object)this));
            stack.consume(1, (LivingEntity)p);
            if (!p.hasInfiniteMaterials()) {
                if (stack.isEmpty()) {
                    return new ItemStack((ItemLike)Items.GLASS_BOTTLE);
                }
                p.getInventory().add(new ItemStack((ItemLike)Items.GLASS_BOTTLE));
            }
        }
        livingEntity.gameEvent((Holder)GameEvent.DRINK);
        return stack;
    }

    protected abstract void applyEffect(Player var1);

    public static class Enduring
    extends BaseElixirItem {
        private final double extraStamina;

        public Enduring(Item.Properties properties, double extraStamina) {
            super(properties);
            this.extraStamina = extraStamina;
        }

        @Override
        protected void applyEffect(Player player) {
            Stamina stamina = Stamina.get(player);
            double extraStamina = stamina.extraStamina();
            if (extraStamina < this.extraStamina) {
                stamina.setExtraStamina(this.extraStamina);
            }
        }

        public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> tooltipComponents, @NotNull TooltipFlag tooltipFlag) {
            tooltipComponents.add((Component)Component.translatable((String)"tooltip.paraglider.give_extra_stamina", (Object[])new Object[]{Component.literal((String)D0.format(this.extraStamina / 1000.0)).withStyle(ChatFormatting.YELLOW)}).withStyle(ChatFormatting.GREEN));
        }
    }

    public static class Energizing
    extends BaseElixirItem {
        private final double staminaRecovered;
        private final int staminaEfficiencyLevel;
        private final int staminaEfficiencyDuration;

        public Energizing(Item.Properties properties, double staminaRecovered) {
            this(properties, staminaRecovered, -1, 0);
        }

        public Energizing(Item.Properties properties, double staminaRecovered, int staminaEfficiencyLevel, int staminaEfficiencyDuration) {
            super(properties);
            this.staminaRecovered = staminaRecovered;
            this.staminaEfficiencyLevel = staminaEfficiencyLevel;
            this.staminaEfficiencyDuration = staminaEfficiencyDuration;
        }

        @Override
        protected void applyEffect(Player player) {
            Stamina stamina = Stamina.get(player);
            stamina.giveStamina(this.staminaRecovered, false);
            if (this.staminaEfficiencyLevel >= 0 && this.staminaEfficiencyDuration > 0) {
                player.addEffect(new MobEffectInstance(Contents.get().staminaEfficiencyEffect, this.staminaEfficiencyDuration, this.staminaEfficiencyLevel));
            }
        }

        public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> tooltipComponents, @NotNull TooltipFlag tooltipFlag) {
            tooltipComponents.add((Component)Component.translatable((String)"tooltip.paraglider.restore_stamina", (Object[])new Object[]{Component.literal((String)D0.format(this.staminaRecovered / 1000.0)).withStyle(ChatFormatting.YELLOW)}).withStyle(ChatFormatting.GREEN));
            if (this.staminaEfficiencyLevel >= 0 && this.staminaEfficiencyDuration > 0) {
                tooltipComponents.add((Component)Component.translatable((String)"tooltip.paraglider.give_stamina_efficiency", (Object[])new Object[]{Component.literal((String)PCT.format(0.5 * (double)(this.staminaEfficiencyLevel + 1))).withStyle(ChatFormatting.YELLOW), Component.literal((String)D0.format((double)this.staminaEfficiencyDuration / 20.0)).withStyle(ChatFormatting.YELLOW)}).withStyle(ChatFormatting.GREEN));
            }
        }
    }
}

