/*
 * Decompiled with CFR 0.152.
 */
package tictim.paraglider.contents.loot;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Locale;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.neoforged.neoforge.common.loot.IGlobalLootModifier;
import net.neoforged.neoforge.common.loot.LootModifier;
import org.jetbrains.annotations.NotNull;
import tictim.paraglider.config.Cfg;
import tictim.paraglider.config.FeatureCfg;
import tictim.paraglider.contents.Contents;

public class ConfigurableSpiritOrbLoot
extends LootModifier {
    public static final MapCodec<ConfigurableSpiritOrbLoot> CODEC = RecordCodecBuilder.mapCodec(b -> b.group((App)StringRepresentable.fromEnum(Type::values).fieldOf("lootType").forGetter(m -> m.type)).and(ConfigurableSpiritOrbLoot.codecStart((RecordCodecBuilder.Instance)b).t1()).apply((Applicative)b, ConfigurableSpiritOrbLoot::new));
    private final Type type;

    public ConfigurableSpiritOrbLoot(@NotNull Type type, LootItemCondition ... conditions) {
        super(conditions);
        this.type = type;
    }

    @NotNull
    protected ObjectArrayList<ItemStack> doApply(@NotNull ObjectArrayList<ItemStack> generatedLoot, @NotNull LootContext context) {
        if (FeatureCfg.get().enableSpiritOrbGens()) {
            double drops;
            switch (this.type.ordinal()) {
                default: {
                    throw new MatchException(null, null);
                }
                case 0: {
                    double d = Cfg.get().spawnerSpiritOrbDrops();
                    break;
                }
                case 1: {
                    double d = Cfg.get().trialSpiritOrbDrops();
                    break;
                }
                case 2: {
                    double d = drops = Cfg.get().ominousTrialSpiritOrbDrops();
                }
            }
            if (drops > 0.0) {
                int count = (int)drops;
                double frac = drops % 1.0;
                if (frac > 0.0 && context.getRandom().nextDouble() < frac) {
                    ++count;
                }
                if (count > 0) {
                    generatedLoot.add((Object)new ItemStack((ItemLike)Contents.get().spiritOrb(), count));
                }
            }
        }
        return generatedLoot;
    }

    @NotNull
    public MapCodec<? extends IGlobalLootModifier> codec() {
        return CODEC;
    }

    public static enum Type implements StringRepresentable
    {
        SPAWNER,
        TRIAL,
        OMINOUS_TRIAL;

        private final String serializedName = this.name().toLowerCase(Locale.ROOT);

        @NotNull
        public String getSerializedName() {
            return this.serializedName;
        }
    }
}

