/*
 * Decompiled with CFR 0.152.
 */
package tictim.paraglider.contents.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Objects;
import java.util.function.Predicate;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Range;

public record QuantifiedIngredient(@NotNull Ingredient ingredient, @Range(from=0L, to=0x7FFFFFFFL) int quantity) implements Predicate<ItemStack>
{
    public static final MapCodec<QuantifiedIngredient> CODEC = RecordCodecBuilder.mapCodec(b -> b.group((App)Ingredient.CODEC.fieldOf("ingredient").forGetter(QuantifiedIngredient::ingredient), (App)Codec.INT.fieldOf("quantity").forGetter(QuantifiedIngredient::quantity)).apply((Applicative)b, QuantifiedIngredient::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, QuantifiedIngredient> STREAM_CODEC = StreamCodec.composite((StreamCodec)Ingredient.CONTENTS_STREAM_CODEC, QuantifiedIngredient::ingredient, (StreamCodec)ByteBufCodecs.VAR_INT, QuantifiedIngredient::quantity, QuantifiedIngredient::new);

    public QuantifiedIngredient(@NotNull Ingredient ingredient, int quantity) {
        this.ingredient = Objects.requireNonNull(ingredient);
        this.quantity = Math.max(0, quantity);
    }

    @Override
    public boolean test(ItemStack itemStack) {
        return this.ingredient.test(itemStack);
    }
}

