/*
 * Decompiled with CFR 0.152.
 */
package tictim.paraglider.contents.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Objects;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

public record QuantifiedItem(@NotNull ItemStack item, int quantity) {
    public static final MapCodec<QuantifiedItem> CODEC = RecordCodecBuilder.mapCodec(b -> b.group((App)ItemStack.CODEC.fieldOf("item").forGetter(QuantifiedItem::item), (App)Codec.INT.optionalFieldOf("quantity", (Object)1).forGetter(QuantifiedItem::quantity)).apply((Applicative)b, QuantifiedItem::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, QuantifiedItem> STREAM_CODEC = StreamCodec.composite((StreamCodec)ItemStack.STREAM_CODEC, QuantifiedItem::item, (StreamCodec)ByteBufCodecs.VAR_INT, QuantifiedItem::quantity, QuantifiedItem::new);

    public QuantifiedItem(@NotNull Item item, int quantity) {
        this(new ItemStack((ItemLike)item), Math.max(0, quantity));
    }

    public QuantifiedItem(@NotNull ItemStack item, int quantity) {
        this.item = Objects.requireNonNull(item);
        this.quantity = Math.max(0, quantity);
    }

    @NotNull
    public ItemStack getItem() {
        return this.item;
    }

    public int getQuantity() {
        return this.quantity;
    }

    @NotNull
    public ItemStack getItemWithQuantity() {
        ItemStack copy = this.item.copy();
        copy.setCount(this.quantity);
        return copy;
    }
}

