/*
 * Decompiled with CFR 0.152.
 */
package tictim.paraglider.contents.recipe;

import com.google.common.collect.ImmutableList;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;
import tictim.paraglider.ParagliderMod;
import tictim.paraglider.ParagliderUtils;
import tictim.paraglider.api.bargain.Bargain;
import tictim.paraglider.api.bargain.BargainPreview;
import tictim.paraglider.api.bargain.BargainResult;
import tictim.paraglider.api.vessel.VesselContainer;
import tictim.paraglider.contents.Contents;
import tictim.paraglider.contents.recipe.QuantifiedIngredient;
import tictim.paraglider.contents.recipe.QuantifiedItem;
import tictim.paraglider.contents.recipe.preview.IngredientPreview;
import tictim.paraglider.contents.recipe.preview.ItemPreview;
import tictim.paraglider.contents.recipe.preview.VesselPreview;

public class SimpleBargain
implements Bargain {
    private final ResourceLocation bargainType;
    private final List<QuantifiedIngredient> itemDemands;
    private final int heartContainerDemands;
    private final int staminaVesselDemands;
    private final int essenceDemands;
    private final List<QuantifiedItem> itemOffers;
    private final int heartContainerOffers;
    private final int staminaVesselOffers;
    private final int essenceOffers;
    private final Set<String> userTags;
    private final Set<String> tags;
    @Nullable
    private List<BargainPreview<?>> demandPreviews;
    @Nullable
    private List<BargainPreview<?>> offerPreviews;

    public SimpleBargain(@NotNull ResourceLocation bargainType, @NotNull @NotNull List<@NotNull QuantifiedIngredient> itemDemands, int heartContainerDemands, int staminaVesselDemands, int essenceDemands, @NotNull @NotNull List<@NotNull QuantifiedItem> itemOffers, int heartContainerOffers, int staminaVesselOffers, int essenceOffers, @NotNull @NotNull Set<@NotNull String> userTags) {
        this.bargainType = bargainType;
        this.itemDemands = ImmutableList.copyOf(itemDemands);
        for (QuantifiedIngredient itemDemand : this.itemDemands) {
            Objects.requireNonNull(itemDemand);
        }
        this.heartContainerDemands = Math.max(0, heartContainerDemands);
        this.staminaVesselDemands = Math.max(0, staminaVesselDemands);
        this.essenceDemands = Math.max(0, essenceDemands);
        this.itemOffers = ImmutableList.copyOf(itemOffers);
        this.heartContainerOffers = Math.max(0, heartContainerOffers);
        this.staminaVesselOffers = Math.max(0, staminaVesselOffers);
        this.essenceOffers = Math.max(0, essenceOffers);
        this.userTags = Set.copyOf(userTags);
        this.tags = new ObjectOpenHashSet(userTags);
        if (!this.itemDemands.isEmpty()) {
            this.tags.add("consumes_item");
        }
        if (this.heartContainerDemands > 0) {
            this.tags.add("consumes_heart_container");
        }
        if (this.staminaVesselDemands > 0) {
            this.tags.add("consumes_stamina_vessel");
        }
        if (this.essenceDemands > 0) {
            this.tags.add("consumes_essence");
        }
        if (!this.itemOffers.isEmpty()) {
            this.tags.add("gives_item");
        }
        if (this.heartContainerOffers > 0) {
            this.tags.add("gives_heart_container");
        }
        if (this.staminaVesselOffers > 0) {
            this.tags.add("gives_stamina_vessel");
        }
        if (this.essenceOffers > 0) {
            this.tags.add("gives_essence");
        }
    }

    @Override
    @NotNull
    public ResourceLocation getBargainType() {
        return this.bargainType;
    }

    @NotNull
    public List<QuantifiedIngredient> getItemDemands() {
        return this.itemDemands;
    }

    public int getHeartContainerDemands() {
        return this.heartContainerDemands;
    }

    public int getStaminaVesselDemands() {
        return this.staminaVesselDemands;
    }

    public int getEssenceDemands() {
        return this.essenceDemands;
    }

    @NotNull
    public List<QuantifiedItem> getItemOffers() {
        return this.itemOffers;
    }

    public int getHeartContainerOffers() {
        return this.heartContainerOffers;
    }

    public int getStaminaVesselOffers() {
        return this.staminaVesselOffers;
    }

    public int getEssenceOffers() {
        return this.essenceOffers;
    }

    @NotNull
    public Set<String> getUserTags() {
        return this.userTags;
    }

    @Override
    public boolean isAvailableFor(@NotNull Player player, @Nullable BlockPos pos) {
        return true;
    }

    @Override
    @NotNull
    public @NotNull @Unmodifiable List<@NotNull BargainPreview<?>> previewDemands() {
        if (this.demandPreviews != null) {
            return this.demandPreviews;
        }
        this.demandPreviews = new ArrayList();
        for (QuantifiedIngredient i : this.itemDemands) {
            this.demandPreviews.add(new IngredientPreview(i));
        }
        if (this.heartContainerDemands > 0) {
            this.demandPreviews.add(new VesselPreview(VesselPreview.VesselType.HEART_CONTAINER, this.heartContainerDemands));
        }
        if (this.staminaVesselDemands > 0) {
            this.demandPreviews.add(new VesselPreview(VesselPreview.VesselType.STAMINA_VESSEL, this.staminaVesselDemands));
        }
        if (this.essenceDemands > 0) {
            this.demandPreviews.add(new VesselPreview(VesselPreview.VesselType.ESSENCE, this.essenceDemands));
        }
        return this.demandPreviews;
    }

    @Override
    @NotNull
    public @NotNull @Unmodifiable List<@NotNull BargainPreview<?>> previewOffers() {
        if (this.offerPreviews != null) {
            return this.offerPreviews;
        }
        this.offerPreviews = new ArrayList();
        for (QuantifiedItem i : this.itemOffers) {
            this.offerPreviews.add(new ItemPreview(i));
        }
        if (this.heartContainerOffers > 0) {
            this.offerPreviews.add(new VesselPreview(VesselPreview.VesselType.HEART_CONTAINER, this.heartContainerOffers));
        }
        if (this.staminaVesselOffers > 0) {
            this.offerPreviews.add(new VesselPreview(VesselPreview.VesselType.STAMINA_VESSEL, this.staminaVesselOffers));
        }
        if (this.essenceOffers > 0) {
            this.offerPreviews.add(new VesselPreview(VesselPreview.VesselType.ESSENCE, this.essenceOffers));
        }
        return this.offerPreviews;
    }

    @Override
    public int @NotNull [] countDemands(@NotNull Player player) {
        IntArrayList list = new IntArrayList();
        for (QuantifiedIngredient i : this.itemDemands) {
            list.add(ParagliderUtils.countIngredient(player, i.ingredient()));
        }
        if (this.heartContainerDemands > 0) {
            list.add(VesselContainer.get(player).heartContainer());
        }
        if (this.staminaVesselDemands > 0) {
            list.add(VesselContainer.get(player).staminaVessel());
        }
        if (this.essenceDemands > 0) {
            list.add(VesselContainer.get(player).essence());
        }
        return list.toIntArray();
    }

    @Override
    @NotNull
    public BargainResult bargain(@NotNull Player player, boolean simulate) {
        VesselContainer container = VesselContainer.get(player);
        HashSet<String> reasons = new HashSet<String>();
        Inventory inventory = player.getInventory();
        Int2IntOpenHashMap consumptions = new Int2IntOpenHashMap();
        for (QuantifiedIngredient i : this.itemDemands) {
            if (ParagliderUtils.calculateConsumption(i, (Container)inventory, consumptions)) continue;
            reasons.add("not_enough_items");
            break;
        }
        if (container.takeHeartContainers(this.heartContainerDemands, true, false) < this.heartContainerDemands) {
            reasons.add("not_enough_hearts");
        }
        if (container.takeStaminaVessels(this.staminaVesselDemands, true, false) < this.staminaVesselDemands) {
            reasons.add("not_enough_stamina");
        }
        if (container.takeEssences(this.essenceDemands, true, false) < this.essenceDemands) {
            reasons.add("not_enough_essences");
        }
        if (!reasons.isEmpty()) {
            return BargainResult.fail(reasons);
        }
        int heartDiff = this.heartContainerOffers - this.heartContainerDemands;
        int staminaDiff = this.staminaVesselOffers - this.staminaVesselDemands;
        int essenceDiff = this.essenceOffers - this.essenceDemands;
        if (heartDiff > 0 && container.giveHeartContainers(heartDiff, true, false) < heartDiff) {
            reasons.add("heart_full");
        }
        if (staminaDiff > 0 && container.giveStaminaVessels(staminaDiff, true, false) < staminaDiff) {
            reasons.add("stamina_full");
        }
        if (essenceDiff > 0 && container.giveEssences(essenceDiff, true, false) < essenceDiff) {
            reasons.add("essence_full");
        }
        if (!reasons.isEmpty()) {
            return BargainResult.fail(reasons);
        }
        if (!simulate) {
            for (Int2IntMap.Entry e : consumptions.int2IntEntrySet()) {
                int i = e.getIntKey();
                int c = e.getIntValue();
                if (c <= 0) continue;
                ItemStack stack = inventory.getItem(i);
                if (stack.getCount() > c) {
                    stack.shrink(c);
                    continue;
                }
                if (stack.getCount() != c) {
                    ParagliderMod.LOGGER.error("Quantity of item {} (slot number {}) differs from simulation.", (Object)stack, (Object)i);
                }
                inventory.setItem(i, ItemStack.EMPTY);
            }
            for (QuantifiedItem item : this.itemOffers) {
                ParagliderUtils.giveItem(player, item.getItemWithQuantity());
            }
            if (heartDiff != 0 && (heartDiff > 0 ? container.giveHeartContainers(heartDiff, false, true) != heartDiff : container.takeHeartContainers(-heartDiff, false, true) != -heartDiff)) {
                ParagliderMod.LOGGER.error("Heart Container transaction of bargain failed to resolve after successful simulation.");
            }
            if (staminaDiff != 0 && (staminaDiff > 0 ? container.giveStaminaVessels(staminaDiff, false, true) != staminaDiff : container.takeStaminaVessels(-staminaDiff, false, true) != -staminaDiff)) {
                ParagliderMod.LOGGER.error("Stamina Vessel transaction of bargain failed to resolve after successful simulation.");
            }
            if (essenceDiff != 0 && (essenceDiff > 0 ? container.giveEssences(essenceDiff, false, true) != essenceDiff : container.takeEssences(-essenceDiff, false, true) != -essenceDiff)) {
                ParagliderMod.LOGGER.error("Essence transaction of bargain failed to resolve after successful simulation.");
            }
        }
        return BargainResult.success();
    }

    @Override
    @NotNull
    public @NotNull @Unmodifiable Set<@NotNull String> getBargainTags() {
        return Collections.unmodifiableSet(this.tags);
    }

    @NotNull
    public RecipeSerializer<SimpleBargain> getSerializer() {
        return Contents.get().bargainRecipeSerializer();
    }

    @NotNull
    public RecipeType<Bargain> getType() {
        return Contents.get().bargainRecipeType();
    }
}

