/*
 * Decompiled with CFR 0.152.
 */
package tictim.paraglider.contents.worldgen;

import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.TemplateStructurePiece;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import net.minecraft.world.level.levelgen.structure.templatesystem.BlockIgnoreProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BaseHornedStatuePiece
extends TemplateStructurePiece {
    private boolean savePivot;

    public BaseHornedStatuePiece(@NotNull StructurePieceType type, @NotNull StructureTemplateManager structureManager, @NotNull ResourceLocation location, @NotNull BlockPos templatePos) {
        super(type, 0, structureManager, location, location.toString(), new StructurePlaceSettings().addProcessor((StructureProcessor)BlockIgnoreProcessor.STRUCTURE_BLOCK), templatePos);
    }

    public BaseHornedStatuePiece(@NotNull StructurePieceType type, @NotNull CompoundTag tag, @NotNull StructureTemplateManager structureManager, @NotNull Function<ResourceLocation, StructurePlaceSettings> placeSettingsFactory, boolean savePivot) {
        super(type, tag, structureManager, placeSettingsFactory);
        this.savePivot = savePivot;
    }

    @NotNull
    public static StructurePieceType.StructureTemplateType createType(@NotNull Supplier<StructurePieceType> type) {
        return BaseHornedStatuePiece.createType(type, null);
    }

    @NotNull
    public static StructurePieceType.StructureTemplateType createType(@NotNull Supplier<StructurePieceType> type, @Nullable BlockPos pivot) {
        return (templateManager, tag) -> {
            String oRot = tag.getString("Rot");
            Optional oRotPivot = NbtUtils.readBlockPos((CompoundTag)tag, (String)"RotPivot");
            return new BaseHornedStatuePiece((StructurePieceType)type.get(), tag, templateManager, l -> {
                StructurePlaceSettings s = new StructurePlaceSettings().addProcessor((StructureProcessor)BlockIgnoreProcessor.STRUCTURE_BLOCK);
                if (!oRot.isEmpty()) {
                    s.setRotation(Rotation.valueOf((String)oRot));
                    if (pivot != null) {
                        s.setRotationPivot(pivot);
                    } else {
                        oRotPivot.ifPresent(arg_0 -> ((StructurePlaceSettings)s).setRotationPivot(arg_0));
                    }
                }
                return s;
            }, pivot != null || oRotPivot.isPresent());
        };
    }

    @NotNull
    public BaseHornedStatuePiece rot(@NotNull BlockPos pivot, @NotNull Rotation rot) {
        return this.rot(pivot, rot, true);
    }

    @NotNull
    public BaseHornedStatuePiece rot(@NotNull BlockPos pivot, @NotNull Rotation rot, boolean savePivot) {
        this.placeSettings.setRotationPivot(pivot).setRotation(rot);
        this.savePivot = savePivot;
        return this;
    }

    protected void addAdditionalSaveData(@NotNull StructurePieceSerializationContext context, @NotNull CompoundTag tag) {
        super.addAdditionalSaveData(context, tag);
        if (this.getRotation() != Rotation.NONE) {
            tag.putString("Rot", this.getRotation().name());
            if (this.savePivot) {
                tag.put("RotPivot", NbtUtils.writeBlockPos((BlockPos)this.placeSettings.getRotationPivot()));
            }
        }
    }

    protected void handleDataMarker(@NotNull String function, @NotNull BlockPos pos, @NotNull ServerLevelAccessor accessor, @NotNull RandomSource random, @NotNull BoundingBox boundingBox) {
    }
}

