/*
 * Decompiled with CFR 0.152.
 */
package tictim.paraglider.contents.worldgen;

import com.mojang.serialization.MapCodec;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.EmptyBlockGetter;
import net.minecraft.world.level.NoiseColumn;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import org.jetbrains.annotations.NotNull;
import tictim.paraglider.api.ParagliderAPI;
import tictim.paraglider.contents.Contents;
import tictim.paraglider.contents.worldgen.BaseHornedStatuePiece;

public class UndergroundHornedStatue
extends Structure {
    public static final MapCodec<UndergroundHornedStatue> CODEC = UndergroundHornedStatue.simpleCodec(UndergroundHornedStatue::new);
    private static final ResourceLocation TEMPLATE = ParagliderAPI.id("underground_horned_statue");

    @NotNull
    public static StructurePieceType.StructureTemplateType pieceType() {
        return BaseHornedStatuePiece.createType(() -> Contents.get().undergroundHornedStatuePiece(), BlockPos.ZERO);
    }

    public UndergroundHornedStatue(@NotNull Structure.StructureSettings structureSettings) {
        super(structureSettings);
    }

    @NotNull
    public Optional<Structure.GenerationStub> findGenerationPoint(@NotNull Structure.GenerationContext ctx) {
        int z;
        int x = ctx.chunkPos().getMinBlockX() + ctx.random().nextInt(16);
        int y = UndergroundHornedStatue.searchY(ctx, x, z = ctx.chunkPos().getMinBlockZ() + ctx.random().nextInt(16));
        if (y == Integer.MIN_VALUE) {
            return Optional.empty();
        }
        BlockPos pos = new BlockPos(x, y, z);
        Rotation rotation = Rotation.getRandom((RandomSource)ctx.random());
        return Optional.of(new Structure.GenerationStub(pos, b -> b.addPiece((StructurePiece)new BaseHornedStatuePiece(Contents.get().undergroundHornedStatuePiece(), ctx.structureTemplateManager(), TEMPLATE, pos).rot(BlockPos.ZERO, rotation))));
    }

    private static int searchY(@NotNull Structure.GenerationContext ctx, int x, int z) {
        int y;
        int depth = 17;
        NoiseColumn col = ctx.chunkGenerator().getBaseColumn(x, z, ctx.heightAccessor(), ctx.randomState());
        BlockPos.MutableBlockPos mpos = new BlockPos.MutableBlockPos(x, y, z);
        for (y = ctx.chunkGenerator().getFirstOccupiedHeight(x, z, Heightmap.Types.OCEAN_FLOOR_WG, ctx.heightAccessor(), ctx.randomState()) - ctx.random().nextInt(30); y > -32; --y) {
            BlockState state = col.getBlock(y);
            if (state.getCollisionShape((BlockGetter)EmptyBlockGetter.INSTANCE, (BlockPos)mpos.setY(y)).isEmpty()) {
                if (depth >= 5) continue;
                depth = 5;
                continue;
            }
            if (--depth > 0) continue;
            return y;
        }
        return Integer.MIN_VALUE;
    }

    @NotNull
    public StructureType<?> type() {
        return Contents.get().undergroundHornedStatue();
    }

    @NotNull
    public GenerationStep.Decoration step() {
        return GenerationStep.Decoration.UNDERGROUND_STRUCTURES;
    }
}

