/*
 * Decompiled with CFR 0.152.
 */
package tictim.paraglider.event;

import it.unimi.dsi.fastutil.bytes.Byte2ObjectMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.world.level.LevelAccessor;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import tictim.paraglider.ParagliderUtils;
import tictim.paraglider.client.WindParticleProvider;
import tictim.paraglider.client.settings.ParagliderClientSettings;
import tictim.paraglider.wind.Wind;
import tictim.paraglider.wind.WindChunk;
import tictim.paraglider.wind.WindNode;

@EventBusSubscriber(modid="paraglider", value={Dist.CLIENT})
public final class WindParticleEventHandler {
    private static final IntArrayList xyzList = new IntArrayList();
    private static double windParticleState;

    private WindParticleEventHandler() {
    }

    @SubscribeEvent
    public static void onClientTick(ClientTickEvent.Pre event) {
        if (Minecraft.getInstance().isPaused()) {
            return;
        }
        ClientLevel level = Minecraft.getInstance().level;
        if (level == null) {
            return;
        }
        Wind wind = Wind.of((LevelAccessor)level);
        if (wind == null) {
            return;
        }
        double s2 = (windParticleState += ParagliderClientSettings.get().windParticleFrequency()) - 1.0;
        if (!(s2 >= 0.0)) {
            return;
        }
        windParticleState = s2;
        for (WindChunk windChunk : wind.windChunks()) {
            for (Byte2ObjectMap.Entry e : windChunk.nodes.byte2ObjectEntrySet()) {
                byte xz = e.getByteKey();
                WindNode node = (WindNode)e.getValue();
                do {
                    xyzList.add(windChunk.x(xz));
                    xyzList.add(node.y);
                    xyzList.add(windChunk.z(xz));
                } while ((node = node.next) != null);
            }
        }
        int bound = 5 + xyzList.size() / 3;
        for (int i = 0; i < xyzList.size(); i += 3) {
            int x = xyzList.getInt(i);
            int y = xyzList.getInt(i + 1);
            int z = xyzList.getInt(i + 2);
            if (ParagliderUtils.PARTICLE_RNG.nextInt(bound) != 0) continue;
            level.addAlwaysVisibleParticle((ParticleOptions)WindParticleProvider.PARTICLE_TYPE, (double)x + ParagliderUtils.PARTICLE_RNG.nextDouble(), (double)y + 0.5, (double)z + ParagliderUtils.PARTICLE_RNG.nextDouble(), 0.0, 0.0, 0.0);
        }
        xyzList.clear();
    }
}

