/*
 * Decompiled with CFR 0.152.
 */
package tictim.paraglider.impl.movement;

import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;
import tictim.paraglider.ParagliderUtils;
import tictim.paraglider.api.ParagliderAPI;
import tictim.paraglider.api.stamina.Stamina;
import tictim.paraglider.impl.movement.RemotePlayerMovement;

public class ClientPlayerMovement
extends RemotePlayerMovement {
    private boolean wasParagliding;

    public ClientPlayerMovement(@NotNull LocalPlayer player) {
        super((Player)player);
    }

    @NotNull
    public LocalPlayer player() {
        return (LocalPlayer)super.player();
    }

    @Override
    @NotNull
    protected Stamina createCustomStamina() {
        return ParagliderAPI.staminaFactory().createLocalClientInstance(this.player());
    }

    @Override
    public void update() {
        this.updateStamina();
        boolean paragliding = this.state().paragliding();
        if (!this.player().isCreative() && this.stamina().isDepleted()) {
            this.player().setSprinting(false);
            this.player().setSwimming(false);
            if (this.player().isFallFlying()) {
                this.player().stopFallFlying();
            }
        } else if (this.wasParagliding != paragliding) {
            this.player().setSprinting(paragliding);
            if (!this.wasParagliding && paragliding) {
                ParagliderUtils.playParagliderDeploySound((Player)this.player());
            }
        }
        this.applyMovement();
        this.wasParagliding = paragliding;
    }
}

