/*
 * Decompiled with CFR 0.152.
 */
package tictim.paraglider.impl.movement;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Collections;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;
import tictim.paraglider.ParagliderMod;
import tictim.paraglider.api.movement.ParagliderPlayerStates;
import tictim.paraglider.api.movement.PlayerState;
import tictim.paraglider.impl.movement.SimplePlayerState;

public final class PlayerStateMap {
    public static final StreamCodec<FriendlyByteBuf, PlayerStateMap> STREAM_CODEC = StreamCodec.of((buf, psm) -> psm.write((FriendlyByteBuf)buf), PlayerStateMap::read);
    private final Map<ResourceLocation, PlayerState> states;

    public PlayerStateMap(@NotNull @NotNull Map<@NotNull ResourceLocation, @NotNull PlayerState> states) {
        this.states = Objects.requireNonNull(states);
    }

    @NotNull
    public static PlayerStateMap read(@NotNull FriendlyByteBuf buffer) {
        Object2ObjectOpenHashMap states = new Object2ObjectOpenHashMap();
        int count = buffer.readVarInt();
        for (int i = 0; i < count; ++i) {
            SimplePlayerState state = SimplePlayerState.read(buffer);
            states.put(state.id(), state);
        }
        if (!states.containsKey(ParagliderPlayerStates.IDLE)) {
            ParagliderMod.LOGGER.error("Instance of PlayerStateMap constructed from packet does not have idle state, something is wrong!");
            states.put(ParagliderPlayerStates.IDLE, new SimplePlayerState(ParagliderPlayerStates.IDLE, Set.of(), 20.0, 0));
        }
        return new PlayerStateMap((Map<ResourceLocation, PlayerState>)states);
    }

    @NotNull
    public @NotNull @Unmodifiable Map<@NotNull ResourceLocation, @NotNull PlayerState> states() {
        return Collections.unmodifiableMap(this.states);
    }

    @NotNull
    public PlayerState expectState(@NotNull ResourceLocation id) {
        PlayerState state = this.getState(id);
        if (state == null) {
            throw new NoSuchElementException("No state named " + String.valueOf(id) + " in state map");
        }
        return state;
    }

    @Nullable
    public PlayerState getState(@NotNull ResourceLocation id) {
        return this.states.get(id);
    }

    @NotNull
    public PlayerState getIdleState() {
        return this.expectState(ParagliderPlayerStates.IDLE);
    }

    public void write(@NotNull FriendlyByteBuf buffer) {
        buffer.writeVarInt(this.states.size());
        for (PlayerState state : this.states.values()) {
            SimplePlayerState.write(buffer, state);
        }
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof PlayerStateMap)) {
            return false;
        }
        PlayerStateMap stateMap = (PlayerStateMap)obj;
        return this.states.equals(stateMap.states);
    }

    public int hashCode() {
        return Objects.hash(this.states);
    }

    public String toString() {
        return "PlayerStateMap{states=" + String.valueOf(this.states) + "}";
    }

    public static boolean isSame(PlayerStateMap stateMap1, PlayerStateMap stateMap2) {
        if (stateMap1.states.size() != stateMap2.states.size()) {
            return false;
        }
        for (ResourceLocation key : stateMap1.states.keySet()) {
            PlayerState s2;
            PlayerState s1 = stateMap1.states.get(key);
            if (s1.equals(s2 = stateMap2.states.get(key))) continue;
            return false;
        }
        return true;
    }
}

