/*
 * Decompiled with CFR 0.152.
 */
package tictim.paraglider.impl.stamina;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.world.entity.ai.attributes.Attribute;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Unmodifiable;
import tictim.paraglider.api.plugin.PluginInstance;
import tictim.paraglider.api.stamina.StaminaEfficiencyLogic;
import tictim.paraglider.api.stamina.StaminaPlugin;
import tictim.paraglider.impl.stamina.AttributeStaminaEfficiencyLogic;
import tictim.paraglider.plugin.ParagliderPluginLoader;

public final class StaminaEfficiencyLogicLoader {
    private StaminaEfficiencyLogicLoader() {
    }

    @NotNull
    public static @Unmodifiable List<StaminaEfficiencyLogic> loadStaminaEfficiencyLogics() {
        return StaminaEfficiencyLogicLoader.loadStaminaEfficiencyLogics(ParagliderPluginLoader.get().getStaminaPlugins());
    }

    @NotNull
    public static @Unmodifiable List<StaminaEfficiencyLogic> loadStaminaEfficiencyLogics(@NotNull @NotNull @Unmodifiable List<@NotNull PluginInstance<StaminaPlugin>> plugins) {
        final ArrayList list = new ArrayList();
        for (PluginInstance<StaminaPlugin> plugin : plugins) {
            plugin.instance().registerStaminaEfficiencyLogic(new StaminaPlugin.StaminaEfficiencyLogicRegister(){

                @Override
                public void register(@NotNull StaminaEfficiencyLogic logic) {
                    Objects.requireNonNull(logic, "logic == null");
                    list.add(logic);
                }

                @Override
                public void registerAttribute(@NotNull Supplier<Holder<Attribute>> attribute, @NotNull StaminaPlugin.AttributeEfficiencyCondition condition) {
                    Objects.requireNonNull(attribute, "attribute == null");
                    Objects.requireNonNull(condition, "condition == null");
                    list.add(new AttributeStaminaEfficiencyLogic(attribute, condition));
                }
            });
        }
        return List.copyOf(list);
    }
}

