/*
 * Decompiled with CFR 0.152.
 */
package tictim.paraglider.network;

import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.handling.DirectionalPayloadHandler;
import net.neoforged.neoforge.network.handling.IPayloadHandler;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tictim.paraglider.ParagliderMod;
import tictim.paraglider.bargain.BargainCatalog;
import tictim.paraglider.bargain.BargainContext;
import tictim.paraglider.impl.movement.PlayerStateMap;
import tictim.paraglider.network.ClientPacketHandler;
import tictim.paraglider.network.Kind;
import tictim.paraglider.network.ParagliderNetwork;
import tictim.paraglider.network.ServerPacketHandler;
import tictim.paraglider.network.message.BargainDialogMsg;
import tictim.paraglider.network.message.BargainEndMsg;
import tictim.paraglider.network.message.BargainInitMsg;
import tictim.paraglider.network.message.BargainMsg;
import tictim.paraglider.network.message.SyncCatalogMsg;
import tictim.paraglider.network.message.SyncLookAtMsg;
import tictim.paraglider.network.message.SyncMovementMsg;
import tictim.paraglider.network.message.SyncPlayerStateMapMsg;
import tictim.paraglider.network.message.SyncRemoteMovementMsg;
import tictim.paraglider.network.message.SyncVesselMsg;
import tictim.paraglider.network.message.SyncWindMsg;
import tictim.paraglider.wind.WindChunk;

public class ParagliderNetworkImpl
implements ParagliderNetwork {
    public static final String NETVERSION = "3";

    public ParagliderNetworkImpl(IEventBus eventBus) {
        eventBus.addListener(this::register);
    }

    private void register(RegisterPayloadHandlersEvent event) {
        PayloadRegistrar reg = event.registrar(NETVERSION);
        reg.commonToClient(SyncPlayerStateMapMsg.TYPE, SyncPlayerStateMapMsg.CODEC, (msg, ctx) -> ClientPacketHandler.handleSyncPlayerStateMap(msg));
        reg.playToClient(SyncMovementMsg.TYPE, SyncMovementMsg.CODEC, (msg, ctx) -> ClientPacketHandler.handleSyncMovement(msg));
        reg.playToClient(SyncRemoteMovementMsg.TYPE, SyncRemoteMovementMsg.CODEC, (msg, ctx) -> ClientPacketHandler.handleSyncRemoteMovement(msg));
        reg.playToClient(SyncVesselMsg.TYPE, SyncVesselMsg.CODEC, (msg, ctx) -> ClientPacketHandler.handleSyncVessel(msg));
        reg.playToClient(BargainInitMsg.TYPE, BargainInitMsg.CODEC, (msg, ctx) -> ClientPacketHandler.handleBargainInit(msg));
        reg.playToClient(SyncCatalogMsg.TYPE, SyncCatalogMsg.CODEC, (msg, ctx) -> ClientPacketHandler.handleSyncCatalog(msg));
        reg.playToClient(SyncLookAtMsg.TYPE, SyncLookAtMsg.CODEC, (msg, ctx) -> ClientPacketHandler.handleSyncLookAt(msg));
        reg.playToClient(BargainDialogMsg.TYPE, BargainDialogMsg.CODEC, (msg, ctx) -> ClientPacketHandler.handleBargainDialog(msg));
        reg.playToClient(SyncWindMsg.TYPE, SyncWindMsg.CODEC, (msg, ctx) -> ClientPacketHandler.handleSyncWind(msg));
        reg.playToServer(BargainMsg.TYPE, BargainMsg.CODEC, ServerPacketHandler::handleBargain);
        reg.playBidirectional(BargainEndMsg.TYPE, BargainEndMsg.CODEC, (IPayloadHandler)new DirectionalPayloadHandler((msg, ctx) -> ClientPacketHandler.handleBargainEnd(msg), ServerPacketHandler::handleBargainEnd));
    }

    @Override
    public void syncStateMap(@NotNull ServerPlayer player, @NotNull PlayerStateMap stateMap) {
        SyncPlayerStateMapMsg msg = new SyncPlayerStateMapMsg(stateMap);
        ParagliderNetworkImpl.traceSendToPlayer(Kind.MOVEMENT, player, msg);
        PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)msg, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    @Override
    public void syncStateMapToAll(@NotNull MinecraftServer server, @NotNull PlayerStateMap stateMap) {
        SyncPlayerStateMapMsg msg = new SyncPlayerStateMapMsg(stateMap);
        ParagliderNetworkImpl.traceSendToAll(Kind.MOVEMENT, msg);
        PacketDistributor.sendToAllPlayers((CustomPacketPayload)msg, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    @Override
    public void syncMovement(@NotNull ServerPlayer player, @NotNull ResourceLocation state, double stamina, double extraStamina, boolean depleted, int recoveryDelay, double efficiency) {
        SyncMovementMsg msg = new SyncMovementMsg(state, stamina, extraStamina, depleted, recoveryDelay, efficiency);
        ParagliderNetworkImpl.traceSendToPlayer(Kind.MOVEMENT, player, msg);
        PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)msg, (CustomPacketPayload[])new CustomPacketPayload[0]);
        this.syncRemoteMovement(player.server, (Entity)player, state);
    }

    @Override
    public void syncRemoteMovement(@NotNull MinecraftServer server, @NotNull Entity entity, @NotNull ResourceLocation state) {
        SyncRemoteMovementMsg msg = new SyncRemoteMovementMsg(entity.getUUID(), state);
        ParagliderNetworkImpl.traceSendToTracking(Kind.MOVEMENT, entity, (CustomPacketPayload)msg);
        PacketDistributor.sendToPlayersTrackingEntity((Entity)entity, (CustomPacketPayload)msg, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    @Override
    public void syncRemoteMovement(@NotNull Entity entity, @NotNull ServerPlayer target, @NotNull ResourceLocation state) {
        SyncRemoteMovementMsg msg = new SyncRemoteMovementMsg(entity.getUUID(), state);
        ParagliderNetworkImpl.traceSendToPlayer(Kind.MOVEMENT, target, msg);
        PacketDistributor.sendToPlayer((ServerPlayer)target, (CustomPacketPayload)msg, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    @Override
    public void syncVessels(@NotNull ServerPlayer player, double stamina, double extraStamina, boolean depleted, int heartContainers, int staminaVessels) {
        SyncVesselMsg msg = new SyncVesselMsg(stamina, extraStamina, depleted, heartContainers, staminaVessels);
        ParagliderNetworkImpl.traceSendToPlayer(Kind.VESSEL, player, msg);
        PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)msg, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    @Override
    public void initBargain(@NotNull BargainContext ctx, @Nullable Component dialog) {
        BargainInitMsg msg = new BargainInitMsg(ctx.sessionId(), ctx.makeCatalog(), ctx.lookAt(), dialog);
        ParagliderNetworkImpl.traceSendToPlayer(Kind.BARGAIN, ctx.player(), msg);
        PacketDistributor.sendToPlayer((ServerPlayer)ctx.player(), (CustomPacketPayload)msg, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    @Override
    public void syncBargainCatalog(@NotNull BargainContext ctx, @NotNull List<BargainCatalog> catalog) {
        SyncCatalogMsg msg = new SyncCatalogMsg(ctx.sessionId(), catalog);
        ParagliderNetworkImpl.traceSendToPlayer(Kind.BARGAIN, ctx.player(), msg);
        PacketDistributor.sendToPlayer((ServerPlayer)ctx.player(), (CustomPacketPayload)msg, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    @Override
    public void syncBargainLookAt(@NotNull BargainContext ctx, @Nullable Vec3 lookAt) {
        SyncLookAtMsg msg = new SyncLookAtMsg(ctx.sessionId(), lookAt);
        ParagliderNetworkImpl.traceSendToPlayer(Kind.BARGAIN, ctx.player(), msg);
        PacketDistributor.sendToPlayer((ServerPlayer)ctx.player(), (CustomPacketPayload)msg, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    @Override
    public void displayBargainDialog(@NotNull BargainContext ctx, @NotNull Component dialog) {
        BargainDialogMsg msg = new BargainDialogMsg(ctx.sessionId(), dialog);
        ParagliderNetworkImpl.traceSendToPlayer(Kind.BARGAIN, ctx.player(), msg);
        PacketDistributor.sendToPlayer((ServerPlayer)ctx.player(), (CustomPacketPayload)msg, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    @Override
    public void bargain(int sessionId, @NotNull ResourceLocation bargain) {
        BargainMsg msg = new BargainMsg(sessionId, bargain);
        ParagliderNetworkImpl.traceSendToServer(Kind.BARGAIN, msg);
        PacketDistributor.sendToServer((CustomPacketPayload)msg, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    @Override
    public void bargainEndToClient(@NotNull BargainContext ctx) {
        BargainEndMsg msg = new BargainEndMsg(ctx.sessionId());
        ParagliderNetworkImpl.traceSendToPlayer(Kind.BARGAIN, ctx.player(), msg);
        PacketDistributor.sendToPlayer((ServerPlayer)ctx.player(), (CustomPacketPayload)msg, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    @Override
    public void bargainEndToServer(int sessionId) {
        BargainEndMsg msg = new BargainEndMsg(sessionId);
        ParagliderNetworkImpl.traceSendToServer(Kind.BARGAIN, msg);
        PacketDistributor.sendToServer((CustomPacketPayload)msg, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    @Override
    public void syncWind(@NotNull MinecraftServer server, @NotNull LevelChunk chunk, @NotNull WindChunk windChunk) {
        SyncWindMsg msg = new SyncWindMsg(windChunk);
        ParagliderNetworkImpl.traceSendToTracking(Kind.WIND, chunk, (CustomPacketPayload)msg);
        Level level = chunk.getLevel();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)serverLevel, (ChunkPos)chunk.getPos(), (CustomPacketPayload)msg, (CustomPacketPayload[])new CustomPacketPayload[0]);
        } else {
            ParagliderMod.LOGGER.warn("Failed to send packet {}, not a server level", (Object)msg);
        }
    }

    protected static void traceSendToAll(@NotNull Kind kind, @NotNull CustomPacketPayload msg) {
        if (kind.isTraceEnabled()) {
            ParagliderMod.LOGGER.debug("Dispatching {} to clients", (Object)msg);
        }
    }

    protected static void traceSendToPlayer(@NotNull Kind kind, @NotNull ServerPlayer player, @NotNull CustomPacketPayload msg) {
        if (kind.isTraceEnabled()) {
            ParagliderMod.LOGGER.debug("Dispatching {} to {}", (Object)msg, (Object)player);
        }
    }

    protected static void traceSendToTracking(@NotNull Kind kind, @NotNull Entity entity, @NotNull CustomPacketPayload msg) {
        if (kind.isTraceEnabled()) {
            ParagliderMod.LOGGER.debug("Dispatching {} to clients tracking entity {}", (Object)msg, (Object)entity);
        }
    }

    protected static void traceSendToTracking(@NotNull Kind kind, @NotNull LevelChunk chunk, @NotNull CustomPacketPayload msg) {
        if (kind.isTraceEnabled()) {
            ParagliderMod.LOGGER.debug("Dispatching {} to clients tracking chunk {}", (Object)msg, (Object)chunk);
        }
    }

    protected static void traceSendToServer(@NotNull Kind kind, @NotNull CustomPacketPayload msg) {
        if (kind.isTraceEnabled()) {
            ParagliderMod.LOGGER.debug("Dispatching {} to server", (Object)msg);
        }
    }
}

