/*
 * Decompiled with CFR 0.152.
 */
package tictim.paraglider.network;

import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;
import tictim.paraglider.ParagliderMod;
import tictim.paraglider.ParagliderUtils;
import tictim.paraglider.api.bargain.Bargain;
import tictim.paraglider.api.bargain.BargainResult;
import tictim.paraglider.bargain.BargainContext;
import tictim.paraglider.bargain.BargainHandler;
import tictim.paraglider.network.Kind;
import tictim.paraglider.network.ParagliderNetwork;
import tictim.paraglider.network.message.BargainEndMsg;
import tictim.paraglider.network.message.BargainMsg;

public final class ServerPacketHandler {
    private ServerPacketHandler() {
    }

    public static void handleBargain(BargainMsg msg, IPayloadContext ctx) {
        Component c;
        ResourceLocation advancement;
        Player player = ctx.player();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        ServerPacketHandler.trace(Kind.BARGAIN, player2, msg);
        BargainContext bargainContext = BargainHandler.getBargain(player2);
        if (bargainContext == null || bargainContext.sessionId() != msg.sessionId()) {
            return;
        }
        Bargain bargain = bargainContext.bargains().get(msg.bargain());
        if (bargain == null) {
            return;
        }
        BargainResult result = bargain.bargain((Player)player2, false);
        if (result.isSuccess() && (advancement = bargainContext.advancement()) != null) {
            ParagliderUtils.giveAdvancement(player2, advancement, "bargain");
        }
        Component component = c = result.isSuccess() ? bargainContext.type().dialog().randomSuccessDialog(ParagliderUtils.DIALOG_RNG, bargain.getBargainTags()) : bargainContext.type().dialog().randomFailDialog(ParagliderUtils.DIALOG_RNG, bargain.getBargainTags(), result.failReasons());
        if (c != null) {
            ParagliderNetwork.get().displayBargainDialog(bargainContext, c);
        }
    }

    public static void handleBargainEnd(BargainEndMsg msg, IPayloadContext ctx) {
        Player player = ctx.player();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        ServerPacketHandler.trace(Kind.BARGAIN, player2, msg);
        BargainContext bargainContext = BargainHandler.getBargain(player2);
        if (bargainContext != null && bargainContext.sessionId() == msg.sessionId()) {
            bargainContext.markFinished();
        }
    }

    private static void trace(@NotNull Kind kind, @NotNull ServerPlayer player, @NotNull CustomPacketPayload msg) {
        if (kind.isTraceEnabled()) {
            ParagliderMod.LOGGER.debug("Received {} from client {}", (Object)msg, (Object)player);
        }
    }
}

