/*
 * Decompiled with CFR 0.152.
 */
package tictim.paraglider.plugin;

import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import tictim.paraglider.ParagliderUtils;
import tictim.paraglider.api.movement.MovementPlugin;
import tictim.paraglider.api.movement.MovementPluginAction;
import tictim.paraglider.api.movement.ParagliderPlayerStates;
import tictim.paraglider.api.plugin.ConflictResolver;
import tictim.paraglider.api.plugin.ParagliderPlugin;
import tictim.paraglider.api.stamina.StaminaPlugin;
import tictim.paraglider.config.Cfg;
import tictim.paraglider.contents.Contents;
import tictim.paraglider.contents.ParagliderTags;
import tictim.paraglider.wind.Wind;

@ParagliderPlugin
public class ParagliderDefaultPlugin
implements MovementPlugin,
StaminaPlugin {
    @Override
    public void registerNewStates(@NotNull MovementPlugin.PlayerStateRegister register) {
        register.register(ParagliderPlayerStates.IDLE, 20.0, new ResourceLocation[0]);
        register.register(ParagliderPlayerStates.FLYING, 20.0, new ResourceLocation[0]);
        register.register(ParagliderPlayerStates.CREATIVE_FLYING, 20.0, new ResourceLocation[0]);
        register.register(ParagliderPlayerStates.ELYTRA_FLYING, 0.0, new ResourceLocation[0]);
        register.register(ParagliderPlayerStates.ON_VEHICLE, 20.0, new ResourceLocation[0]);
        register.register(ParagliderPlayerStates.SWIMMING, -6.0, ParagliderPlayerStates.Flags.DISABLED_BY_RUNNING_CONFIG, ParagliderPlayerStates.Flags.IS_SPRINTING, ParagliderPlayerStates.Flags.IS_UNDERWATER);
        register.register(ParagliderPlayerStates.UNDERWATER, 3.0, ParagliderPlayerStates.Flags.DISABLED_BY_RUNNING_CONFIG, ParagliderPlayerStates.Flags.IS_UNDERWATER);
        register.register(ParagliderPlayerStates.BREATHING_UNDERWATER, 20.0, ParagliderPlayerStates.Flags.DISABLED_BY_RUNNING_CONFIG, ParagliderPlayerStates.Flags.IS_UNDERWATER);
        register.register(ParagliderPlayerStates.PARAGLIDING, -3.0, ParagliderPlayerStates.Flags.DISABLED_BY_PARAGLIDING_CONFIG, ParagliderPlayerStates.Flags.PARAGLIDING, ParagliderPlayerStates.Flags.IS_PARAGLIDING);
        register.register(ParagliderPlayerStates.PANIC_PARAGLIDING, -3.0, ParagliderPlayerStates.Flags.PARAGLIDING, ParagliderPlayerStates.Flags.DISABLED_BY_PARAGLIDING_CONFIG, ParagliderPlayerStates.Flags.IS_PARAGLIDING);
        register.register(ParagliderPlayerStates.ASCENDING, -3.0, ParagliderPlayerStates.Flags.PARAGLIDING, ParagliderPlayerStates.Flags.ASCENDING, ParagliderPlayerStates.Flags.DISABLED_BY_PARAGLIDING_CONFIG, ParagliderPlayerStates.Flags.IS_PARAGLIDING);
        register.register(ParagliderPlayerStates.RUNNING, -10.0, ParagliderPlayerStates.Flags.DISABLED_BY_RUNNING_CONFIG, ParagliderPlayerStates.Flags.IS_SPRINTING);
        register.register(ParagliderPlayerStates.MIDAIR, 0.0, new ResourceLocation[0]);
    }

    @Override
    public void registerStateConnections(@NotNull MovementPlugin.PlayerStateConnectionRegister register) {
        register.connect(ParagliderPlayerStates.IDLE, ParagliderPlayerStates.FLYING, c -> c.player().getAbilities().flying, 8.0);
        register.connect(ParagliderPlayerStates.FLYING, ParagliderPlayerStates.CREATIVE_FLYING, c -> c.player().isCreative());
        register.connect(ParagliderPlayerStates.IDLE, ParagliderPlayerStates.ELYTRA_FLYING, c -> c.player().isFallFlying(), 7.0);
        register.connect(ParagliderPlayerStates.IDLE, ParagliderPlayerStates.ON_VEHICLE, c -> c.player().getVehicle() != null, 6.0);
        register.connect(ParagliderPlayerStates.IDLE, ParagliderPlayerStates.SWIMMING, c -> c.player().isSwimming(), 5.0);
        register.connect(ParagliderPlayerStates.IDLE, ParagliderPlayerStates.UNDERWATER, c -> c.player().isInWater(), 4.0);
        register.connect(ParagliderPlayerStates.UNDERWATER, ParagliderPlayerStates.BREATHING_UNDERWATER, c -> ParagliderUtils.canBreatheUnderwater((Player)c.player()));
        register.connect(ParagliderPlayerStates.IDLE, ParagliderPlayerStates.PARAGLIDING, c -> {
            if (c.player().onGround()) {
                return false;
            }
            if (!ParagliderUtils.canUseParaglider(c)) {
                return false;
            }
            ItemStack stack = c.player().getMainHandItem();
            return stack.is(ParagliderTags.PARAGLIDERS) && ParagliderUtils.getCaps(stack).canDoParagliding((Player)c.player(), stack);
        }, 3.0);
        register.connect(ParagliderPlayerStates.PARAGLIDING, ParagliderPlayerStates.PANIC_PARAGLIDING, c -> c.accumulatedFallDistance() >= (double)1.45f && c.stamina().isDepleted());
        register.connect(ParagliderPlayerStates.PARAGLIDING, ParagliderPlayerStates.ASCENDING, c -> Cfg.get().updraft() && Wind.getWindAbove(c.player().level(), c.player().getBoundingBox()) > 0.0);
        register.connect(ParagliderPlayerStates.PARAGLIDING, ParagliderPlayerStates.IDLE, c -> c.accumulatedFallDistance() < (double)1.45f && !c.prevState().paragliding());
        register.connect(ParagliderPlayerStates.IDLE, ParagliderPlayerStates.RUNNING, c -> c.player().isSprinting() && !c.player().isUsingItem(), 2.0);
        register.connect(ParagliderPlayerStates.IDLE, ParagliderPlayerStates.MIDAIR, c -> !c.player().onGround(), 1.0);
    }

    @Override
    public void registerStaminaEfficiencyLogic(@NotNull StaminaPlugin.StaminaEfficiencyLogicRegister register) {
        Contents contents = Contents.get();
        register.registerAttribute(contents::staminaEfficiency, (d, c, p) -> d < 0.0 && c.state() != null);
        register.registerAttribute(contents::staminaRecovery, (d, c, p) -> d > 0.0 && c.state() != null);
        register.registerAttribute(contents::paraglidingStaminaEfficiency, (d, c, p) -> d < 0.0 && c.stateHasFlag(ParagliderPlayerStates.Flags.IS_PARAGLIDING));
        register.registerAttribute(contents::runningStaminaEfficiency, (d, c, p) -> d < 0.0 && c.stateIs(ParagliderPlayerStates.RUNNING));
        register.registerAttribute(contents::swimmingStaminaEfficiency, (d, c, p) -> d < 0.0 && c.stateIs(ParagliderPlayerStates.SWIMMING));
    }

    @Override
    @NotNull
    public ConflictResolver<MovementPlugin, MovementPluginAction> getMovementPluginConflictResolver() {
        return (a, p) -> {
            if (a instanceof MovementPluginAction.NewState) {
                return ConflictResolver.Resolution.PROCEED;
            }
            return ConflictResolver.Resolution.ABORT;
        };
    }
}

