/*
 * Decompiled with CFR 0.152.
 */
package tictim.paraglider.wind;

import net.minecraft.network.FriendlyByteBuf;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class WindNode {
    private static final long WIND_LIFESPAN = 200L;
    public int y;
    public int height;
    public long createdTime;
    public long updatedTime;
    @Nullable
    public WindNode next;

    private WindNode() {
    }

    public WindNode(int y, int height, long createdTime) {
        this(y, height, createdTime, createdTime);
    }

    public WindNode(int y, int height, long createdTime, long updatedTime) {
        this.y = y;
        this.height = height;
        this.createdTime = createdTime;
        this.updatedTime = updatedTime;
    }

    public WindNode(@NotNull FriendlyByteBuf buf) {
        short size = buf.readUnsignedByte();
        this.read(buf);
        WindNode currentNode = this;
        while ((size = (short)(size - 1)) > 0) {
            WindNode next = new WindNode();
            next.read(buf);
            currentNode = currentNode.next = next;
        }
    }

    private void read(@NotNull FriendlyByteBuf buf) {
        this.y = buf.readVarInt();
        this.height = buf.readVarInt();
    }

    public boolean isExpired(long gameTime) {
        return gameTime - this.createdTime >= 200L;
    }

    public boolean overwrite(int y, int height, long createdTime) {
        if (this.y < y) {
            if (this.next != null) {
                return this.next.overwrite(y, height, createdTime);
            }
            this.next = new WindNode(y, height, createdTime);
            return true;
        }
        if (this.y == y) {
            this.updatedTime = this.createdTime = createdTime;
            if (this.height != height) {
                this.height = height;
                return true;
            }
            return false;
        }
        WindNode node = new WindNode(this.y, this.height, this.createdTime, this.updatedTime);
        node.next = this.next;
        this.next = node;
        this.y = y;
        this.height = height;
        this.updatedTime = this.createdTime = createdTime;
        return true;
    }

    public void write(@NotNull FriendlyByteBuf buf) {
        int w = buf.writerIndex();
        buf.writeByte(0);
        int size = 0;
        WindNode n = this;
        while (n != null) {
            n.writeThis(buf);
            ++size;
            n = n.next;
        }
        buf.setByte(w, Math.min(size, 255));
    }

    private void writeThis(@NotNull FriendlyByteBuf buf) {
        buf.writeVarInt(this.y);
        buf.writeVarInt(this.height);
    }
}

