/*
 * Decompiled with CFR 0.152.
 */
package tictim.paraglider.wind;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.lang.runtime.SwitchBootstraps;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record WindSource(@NotNull List<Condition> conditions, int height) {
    public static final int DEFAULT_HEIGHT = 10;
    public static final Codec<WindSource> CODEC = RecordCodecBuilder.create(b -> b.group((App)WindSource.elementOrList(Condition.CODEC, true).fieldOf("conditions").forGetter(WindSource::conditions), (App)Codec.INT.optionalFieldOf("height", (Object)10).forGetter(WindSource::height)).apply((Applicative)b, WindSource::new));

    private static <T> Codec<List<T>> elementOrList(Codec<T> t, boolean nonEmpty) {
        return WindSource.elementOrList(t, nonEmpty ? t.listOf(1, Integer.MAX_VALUE) : t.listOf());
    }

    private static <T> Codec<List<T>> elementOrList(Codec<T> t, Codec<List<T>> tList) {
        return Codec.either(t, tList).xmap(l -> (List)l.map(List::of, Function.identity()), l -> l.size() == 1 ? Either.left(l.getFirst()) : Either.right((Object)l));
    }

    public void check(@Nullable Consumer<@NotNull String> warnings, @Nullable Consumer<@NotNull String> errors) {
        if (this.conditions.isEmpty() && errors != null) {
            errors.accept("No conditions");
        }
        int index = 1;
        for (Condition condition : this.conditions) {
            condition.check(index++, warnings, errors);
        }
        if (this.height <= 0 && warnings != null) {
            warnings.accept("No height");
        }
    }

    public static sealed interface Condition
    permits BlockStateCondition, TagCondition {
        public static final Codec<Condition> CODEC = Codec.xor(BlockStateCondition.CODEC, TagCondition.CODEC).xmap(e -> (Condition)e.map(Function.identity(), Function.identity()), c -> {
            Condition condition = c;
            Objects.requireNonNull(condition);
            Condition selector0$temp = condition;
            int index$1 = 0;
            return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{BlockStateCondition.class, TagCondition.class}, (Object)selector0$temp, index$1)) {
                default -> throw new MatchException(null, null);
                case 0 -> {
                    BlockStateCondition blockStateCondition = (BlockStateCondition)selector0$temp;
                    yield Either.left((Object)blockStateCondition);
                }
                case 1 -> {
                    TagCondition tagCondition = (TagCondition)selector0$temp;
                    yield Either.right((Object)tagCondition);
                }
            };
        });

        public void check(int var1, @Nullable Consumer<@NotNull String> var2, @Nullable Consumer<@NotNull String> var3);
    }

    public record TagCondition(List<TagKey<Block>> tags) implements Condition
    {
        public static final Codec<TagCondition> CODEC = TagKey.codec((ResourceKey)Registries.BLOCK).listOf(1, Integer.MAX_VALUE).xmap(TagCondition::new, TagCondition::tags).fieldOf("tag").codec();

        @Override
        public void check(int index, @Nullable Consumer<@NotNull String> warnings, @Nullable Consumer<@NotNull String> errors) {
            if (this.tags.isEmpty() && errors != null) {
                errors.accept("No tags in condition #" + index);
            }
        }
    }

    public record StateProperty(String name, String value) {
    }

    public record BlockStateCondition(List<Either<Block, ResourceLocation>> block, List<StateProperty> properties) implements Condition
    {
        public static final Codec<BlockStateCondition> CODEC = RecordCodecBuilder.create(b -> b.group((App)WindSource.elementOrList(Codec.either((Codec)BuiltInRegistries.BLOCK.byNameCodec(), (Codec)ResourceLocation.CODEC), true).fieldOf("block").forGetter(BlockStateCondition::block), (App)Codec.unboundedMap((Codec)Codec.STRING, (Codec)Codec.STRING).xmap(m -> m.entrySet().stream().map(e -> new StateProperty((String)e.getKey(), (String)e.getValue())).toList(), l -> l.stream().collect(LinkedHashMap::new, (m, p) -> m.put(p.name, p.value), (m1, m2) -> {})).optionalFieldOf("properties", List.of()).forGetter(BlockStateCondition::properties)).apply((Applicative)b, BlockStateCondition::new));

        @Override
        public void check(int index, @Nullable Consumer<@NotNull String> warnings, @Nullable Consumer<@NotNull String> errors) {
            if (this.block.isEmpty() && errors != null) {
                errors.accept("No blocks in condition #" + index);
            }
        }
    }
}

