/*
 * Decompiled with CFR 0.152.
 */
package tictim.paraglider.wind;

import com.mojang.datafixers.util.Either;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimplePreparableReloadListener;
import net.minecraft.tags.TagKey;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tictim.paraglider.ParagliderMod;
import tictim.paraglider.api.ParagliderAPI;
import tictim.paraglider.config.DebugCfg;
import tictim.paraglider.wind.WindSource;

public class WindSourceRegistry {
    public static final ResourceKey<Registry<WindSource>> REGISTRY_KEY = ResourceKey.createRegistryKey((ResourceLocation)ParagliderAPI.id("wind_sources"));
    private static final Logger LOGGER = LogManager.getLogger((String)"Paraglider - WindSourceRegistry");
    private WindSources windSources = new WindSources(Map.of(), 0);

    @NotNull
    public static WindSourceRegistry get() {
        return ParagliderMod.instance().windSourceRegistry();
    }

    public int maxWindHeight() {
        return this.windSources.maxWindHeight;
    }

    public int getWindSourceHeight(@NotNull BlockState state) {
        Object2IntOpenHashMap<BlockState> map = this.windSources.map.get(state.getBlock());
        if (map != null) {
            return map.getInt((Object)state);
        }
        return 0;
    }

    public record WindSources(Map<Block, Object2IntOpenHashMap<BlockState>> map, int maxWindHeight) {
    }

    public static final class ReloadListener
    extends SimplePreparableReloadListener<Void> {
        private final WindSourceRegistry windSourceRegistry;
        private final RegistryAccess registryAccess;
        private final Map<Block, Object2IntOpenHashMap<BlockState>> windSources = new HashMap<Block, Object2IntOpenHashMap<BlockState>>();
        private int maxWindHeight = 0;

        public ReloadListener(WindSourceRegistry windSourceRegistry, RegistryAccess registryAccess) {
            this.windSourceRegistry = windSourceRegistry;
            this.registryAccess = registryAccess;
        }

        @NotNull
        protected Void prepare(@NotNull ResourceManager resourceManager, @NotNull ProfilerFiller profiler) {
            return null;
        }

        protected void apply(@NotNull Void object, @NotNull ResourceManager resourceManager, @NotNull ProfilerFiller profiler) {
            this.readWindSources();
            this.windSourceRegistry.windSources = new WindSources(this.windSources, this.maxWindHeight);
        }

        private void readWindSources() {
            boolean verbose = DebugCfg.get().verboseWindSourceLoading();
            Registry blocks = this.registryAccess.registryOrThrow(Registries.BLOCK);
            Registry windSourceReg = this.registryAccess.registryOrThrow(REGISTRY_KEY);
            ArrayList blockCache = new ArrayList();
            ArrayList<BlockState> blockStateCache = new ArrayList<BlockState>();
            if (verbose) {
                LOGGER.info("Loading {} wind sources", (Object)windSourceReg.size());
            }
            for (Holder holder : windSourceReg.asHolderIdMap()) {
                WindSource wind = (WindSource)holder.value();
                block5: for (int i = 0; i < wind.conditions().size(); ++i) {
                    WindSource.Condition condition;
                    WindSource.Condition condition2 = wind.conditions().get(i);
                    Objects.requireNonNull(condition2);
                    int n = 0;
                    switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{WindSource.BlockStateCondition.class, WindSource.TagCondition.class}, (Object)condition, n)) {
                        default: {
                            throw new MatchException(null, null);
                        }
                        case 0: {
                            WindSource.BlockStateCondition blockStateCondition = (WindSource.BlockStateCondition)condition;
                            for (Either<Block, ResourceLocation> e : blockStateCondition.block()) {
                                e.ifLeft(blockCache::add);
                                int finalI = i;
                                e.ifRight(id -> LOGGER.warn("{}#{}:Cannot find block with ID {}", (Object)ReloadListener.n(holder), (Object)finalI, id));
                            }
                            for (Block block : blockCache) {
                                if (blockStateCondition.properties().isEmpty()) {
                                    this.add(wind.height(), block, null);
                                    continue;
                                }
                                blockStateCache.addAll((Collection<BlockState>)block.getStateDefinition().getPossibleStates());
                                boolean error = false;
                                for (WindSource.StateProperty property : blockStateCondition.properties()) {
                                    Property p2 = block.getStateDefinition().getProperty(property.name());
                                    if (p2 == null) {
                                        LOGGER.warn("{}#{}: No property with name {} found for block {}; filtering all states", (Object)ReloadListener.n(holder), (Object)i, (Object)property.name(), (Object)ReloadListener.blockId(block));
                                        blockStateCache.clear();
                                        error = true;
                                        break;
                                    }
                                    Optional v = p2.getValue(property.value());
                                    if (v.isEmpty()) {
                                        LOGGER.warn("{}#{}: No value {} present in block {}, property {}; filtering all states", (Object)ReloadListener.n(holder), (Object)i, (Object)property.value(), (Object)property.name(), (Object)ReloadListener.blockId(block));
                                    }
                                    blockStateCache.removeIf(state -> !state.getOptionalValue(p2).equals(v));
                                }
                                if (!error && blockStateCache.isEmpty()) {
                                    LOGGER.warn("{}#{}: All possible states filtered out for block {}", (Object)ReloadListener.n(holder), (Object)i, (Object)ReloadListener.blockId(block));
                                }
                                for (BlockState state2 : blockStateCache) {
                                    this.add(wind.height(), state2.getBlock(), state2);
                                }
                                blockStateCache.clear();
                            }
                            blockCache.clear();
                            continue block5;
                        }
                        case 1: {
                            WindSource.TagCondition tagCondition = (WindSource.TagCondition)condition;
                            for (TagKey<Block> tag : tagCondition.tags()) {
                                boolean found = false;
                                for (Holder h : blocks.getTagOrEmpty(tag)) {
                                    found = true;
                                    this.add(wind.height(), (Block)h.value(), null);
                                }
                                if (found) continue;
                                LOGGER.warn("{}#{}: Empty block tag {}", (Object)ReloadListener.n(holder), (Object)i, (Object)tag.location());
                            }
                        }
                    }
                }
            }
            if (verbose) {
                LOGGER.info("Loaded wind source list for {} blocks", (Object)this.windSources.size());
                for (Map.Entry<Block, Object2IntOpenHashMap<BlockState>> e : this.windSources.entrySet()) {
                    Block block = e.getKey();
                    ResourceLocation blockId = ReloadListener.blockId(block);
                    Object2IntOpenHashMap<BlockState> map = e.getValue();
                    int defaultHeight = map.defaultReturnValue();
                    if (map.isEmpty()) {
                        LOGGER.info("{}: {}", (Object)blockId, (Object)defaultHeight);
                        continue;
                    }
                    LOGGER.info("{}:", (Object)blockId);
                    for (Object2IntMap.Entry e2 : map.object2IntEntrySet()) {
                        BlockState state3 = (BlockState)e2.getKey();
                        LOGGER.info("  {}: {}", (Object)state3.getProperties().stream().map(p -> p.getName() + "=" + ReloadListener.propertyValueToString(state3, p)).collect(Collectors.joining(",")), (Object)e2.getIntValue());
                    }
                    if (defaultHeight <= 0) continue;
                    LOGGER.info("  Fallback: {}", (Object)defaultHeight);
                }
            }
        }

        private static <T> String n(Holder<T> holder) {
            return holder.unwrapKey().map(ResourceKey::location).map(ResourceLocation::toString).orElse("[No ID]");
        }

        private static ResourceLocation blockId(Block block) {
            return BuiltInRegistries.BLOCK.getKey((Object)block);
        }

        private static <T extends Comparable<T>> String propertyValueToString(BlockState state, Property<T> property) {
            return property.getName(state.getValue(property));
        }

        private void add(int height, @NotNull Block block, @Nullable BlockState state) {
            Object2IntOpenHashMap m = this.windSources.computeIfAbsent(block, b -> new Object2IntOpenHashMap());
            if (state == null) {
                int d = m.defaultReturnValue();
                if (d < height) {
                    m.defaultReturnValue(height);
                }
            } else {
                m.mergeInt((Object)state, height, Integer::max);
            }
            this.maxWindHeight = Math.max(this.maxWindHeight, height);
        }
    }
}

