/*
 * Decompiled with CFR 0.152.
 */
package snownee.snow.client;

import java.util.function.Supplier;
import net.fabricmc.fabric.api.renderer.v1.model.FabricBakedModel;
import net.fabricmc.fabric.api.renderer.v1.render.RenderContext;
import net.fabricmc.fabric.impl.client.indigo.renderer.render.BlockRenderInfo;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import snownee.snow.CoreModule;
import snownee.snow.client.ClientHooks;
import snownee.snow.client.RenderAPI;
import snownee.snow.mixin.client.AbstractBlockRenderContextAccess;
import snownee.snow.mixin.client.BlockRenderInfoAccess;

public class FabricRendererRenderAPI
implements RenderAPI {
    private static final BlockState TOP_SLAB = (BlockState)Blocks.OAK_SLAB.defaultBlockState().setValue((Property)SlabBlock.TYPE, (Comparable)SlabType.TOP);
    private final BlockAndTintGetter level;
    private final RenderContext context;
    @Nullable
    private final RenderType renderType;
    private final Supplier<RandomSource> randomSupplier;
    private final BlockState selfState;
    private final BlockPos pos;
    private final BakedModel unwrapped;

    public FabricRendererRenderAPI(BlockAndTintGetter level, RenderContext context, @Nullable RenderType renderType, Supplier<RandomSource> randomSupplier, BlockState selfState, BlockPos pos, BakedModel unwrapped) {
        this.level = level;
        this.context = context;
        this.renderType = renderType;
        this.randomSupplier = randomSupplier;
        this.selfState = selfState;
        this.pos = pos;
        this.unwrapped = unwrapped;
    }

    @Override
    public boolean render(BlockState blockState, BakedModel model, double yOffset, RenderAPI.ModelPart part) {
        RenderContext renderContext;
        RandomSource random = this.randomSupplier.get();
        if (this.renderType != null && !model.getRenderTypes(blockState, random, this.context.getModelData()).contains(this.renderType)) {
            return false;
        }
        Vec3 offset = yOffset == 0.0 ? blockState.getOffset((BlockGetter)this.level, this.pos) : blockState.getOffset((BlockGetter)this.level, this.pos).add(0.0, yOffset, 0.0);
        boolean expandModel = part == RenderAPI.ModelPart.CAMO && blockState.is(CoreModule.EXPAND_MODEL);
        this.context.pushTransform(quad -> {
            Block block;
            if (part == RenderAPI.ModelPart.SNOW_LAYER && yOffset != 0.0) {
                if (quad.nominalFace() == Direction.DOWN) {
                    return false;
                }
                if (quad.cullFace() != null) {
                    quad.cullFace(null);
                }
            }
            if (part == RenderAPI.ModelPart.CAMO && quad.nominalFace() == Direction.UP && ((block = blockState.getBlock()) instanceof StairBlock || block instanceof SlabBlock || block instanceof WallBlock)) {
                return false;
            }
            int color = -1;
            if (quad.colorIndex() != -1) {
                color = Minecraft.getInstance().getBlockColors().getColor(blockState, this.level, this.pos, quad.colorIndex());
                color |= 0xFF000000;
            }
            if (expandModel || offset != Vec3.ZERO || color != -1) {
                for (int i = 0; i < 4; ++i) {
                    float x = quad.x(i) + (float)offset.x;
                    float y = quad.y(i) + (float)offset.y;
                    float z = quad.z(i) + (float)offset.z;
                    if (expandModel) {
                        x = FabricRendererRenderAPI.expandModel(x);
                        y = FabricRendererRenderAPI.expandModel(y);
                        z = FabricRendererRenderAPI.expandModel(z);
                    }
                    quad.pos(i, x, y, z);
                    quad.color(i, color);
                }
            }
            return true;
        });
        if (blockState == this.selfState && model != ClientHooks.cachedOverlayModel) {
            model = this.unwrapped;
        }
        if ((renderContext = this.context) instanceof AbstractBlockRenderContextAccess) {
            AbstractBlockRenderContextAccess blockRenderContext = (AbstractBlockRenderContextAccess)renderContext;
            BlockRenderInfo blockInfo = blockRenderContext.getBlockInfo();
            boolean generalOverlay = part == RenderAPI.ModelPart.SNOW_OVERLAY && offset.y <= -1.0;
            blockInfo.prepareForBlock(generalOverlay ? TOP_SLAB : blockState, this.pos, model.useAmbientOcclusion(), this.context.getModelData(), this.renderType);
            if (generalOverlay) {
                ((BlockRenderInfoAccess)blockInfo).setDefaultLayer(RenderType.cutout());
                blockInfo.blockPos = this.pos.below();
                for (Direction direction : Direction.Plane.HORIZONTAL) {
                    this.context.isFaceCulled(direction);
                }
                blockInfo.blockPos = this.pos;
            }
        }
        ((FabricBakedModel)model).emitBlockQuads(this.level, blockState, this.pos, this.randomSupplier, this.context);
        this.context.popTransform();
        return true;
    }

    private static float expandModel(float f) {
        if (Mth.equal((float)f, (float)0.0f)) {
            return f - 0.001f;
        }
        if (Mth.equal((float)f, (float)1.0f)) {
            return f + 0.001f;
        }
        return f;
    }

    @Override
    public BlockAndTintGetter level() {
        return this.level;
    }

    @Override
    public BlockPos pos() {
        return this.pos;
    }
}

