/*
 * Decompiled with CFR 0.152.
 */
package snownee.snow.network;

import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import org.jetbrains.annotations.NotNull;
import snownee.kiwi.network.KPacketSender;
import snownee.kiwi.network.KiwiPacket;
import snownee.kiwi.network.PayloadContext;
import snownee.kiwi.network.PlayPacketHandler;
import snownee.snow.SnowRealMagic;

@KiwiPacket
public record SLavaSmokeEffectPacket(BlockPos pos) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<SLavaSmokeEffectPacket> TYPE = new CustomPacketPayload.Type(SnowRealMagic.id("lava_smoke"));
    private static final RandomSource RANDOM = RandomSource.create();

    public void sendToAround(ServerLevel level) {
        KPacketSender.sendToAround((CustomPacketPayload)this, (ServerLevel)level, null, (Vec3i)this.pos, (double)16.0);
    }

    @NotNull
    public CustomPacketPayload.Type<SLavaSmokeEffectPacket> type() {
        return TYPE;
    }

    public static class Handler
    implements PlayPacketHandler<SLavaSmokeEffectPacket> {
        public static final StreamCodec<RegistryFriendlyByteBuf, SLavaSmokeEffectPacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)BlockPos.STREAM_CODEC, SLavaSmokeEffectPacket::pos, SLavaSmokeEffectPacket::new);

        public void handle(SLavaSmokeEffectPacket packet, PayloadContext payloadContext) {
            payloadContext.execute(() -> {
                ClientLevel level = Minecraft.getInstance().level;
                for (int i = 0; i < 10; ++i) {
                    double d0 = RANDOM.nextGaussian() * 0.02;
                    double d1 = RANDOM.nextGaussian() * 0.02;
                    double d2 = RANDOM.nextGaussian() * 0.02;
                    level.addParticle((ParticleOptions)ParticleTypes.SMOKE, (double)((float)packet.pos.getX() + RANDOM.nextFloat()), (double)packet.pos.getY(), (double)((float)packet.pos.getZ() + RANDOM.nextFloat()), d0, d1, d2);
                }
                level.playLocalSound(packet.pos, SoundEvents.LAVA_AMBIENT, SoundSource.AMBIENT, 0.8f, 0.8f, false);
            });
        }

        public StreamCodec<RegistryFriendlyByteBuf, SLavaSmokeEffectPacket> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

