/*
 * Decompiled with CFR 0.152.
 */
package com.corosus.zombieawareness.loader.neoforge;

import com.corosus.zombieawareness.ZombieAwareness;
import com.corosus.zombieawareness.loader.neoforge.EntityRegistry;
import com.corosus.zombieawareness.loader.neoforge.client.ClientRegistry;
import com.corosus.zombieawareness.loader.neoforge.config.MobListsConfig;
import java.io.File;
import java.util.List;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.players.PlayerList;
import net.minecraft.sounds.SoundEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.server.ServerLifecycleHooks;

@Mod(value="zombieawareness")
public class ZombieAwarenessNeoForge
extends ZombieAwareness {
    public static final DeferredRegister<SoundEvent> SOUND_EVENTS = DeferredRegister.create((Registry)BuiltInRegistries.SOUND_EVENT, (String)"zombieawareness");
    public static ModContainer modContainer;

    public ZombieAwarenessNeoForge(ModContainer container) {
        modContainer = container;
        container.getEventBus().addListener(this::setup);
        EntityRegistry.init(container);
        if (FMLEnvironment.dist.isClient()) {
            container.getEventBus().addListener(ClientRegistry::registerModels);
        }
        container.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)MobListsConfig.CONFIG, "zombieawareness" + File.separator + "MobLists.toml");
        this.init();
    }

    private void setup(FMLCommonSetupEvent event) {
    }

    @Override
    public PlayerList getPlayerList() {
        return ServerLifecycleHooks.getCurrentServer().getPlayerList();
    }

    @Override
    public boolean isModInstalled(String modID) {
        return ModList.get().isLoaded(modID);
    }

    @Override
    public void init() {
        super.init();
        SOUND_EVENTS.register(modContainer.getEventBus());
    }

    @Override
    public SoundEvent register(String name) {
        SOUND_EVENTS.register(name, () -> {
            SoundEvent event = SoundEvent.createVariableRangeEvent((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"zombieawareness", (String)name));
            this.lookupStringToEvent.put(name, event);
            return event;
        });
        return null;
    }

    @Override
    public List<? extends String> getEnhancedMobs() {
        return (List)MobListsConfig.GENERAL.enhancedMobs.get();
    }
}

