/*
 * Decompiled with CFR 0.152.
 */
package forge.com.cursee.time_on_display;

import com.cursee.monolib.core.sailing.Sailing;
import forge.com.cursee.time_on_display.Constants;
import forge.com.cursee.time_on_display.TimeOnDisplay;
import forge.com.cursee.time_on_display.core.TimeOnDisplayConfig;
import forge.com.cursee.time_on_display.core.TimeOnDisplayKeyBindForge;
import forge.com.cursee.time_on_display.core.TimeOnDisplayOverlayForge;
import java.lang.reflect.Field;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.LayeredDraw;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;

@Mod(value="time_on_display")
public class TimeOnDisplayForge {
    public static boolean displayToggle = false;

    public TimeOnDisplayForge() {
        TimeOnDisplay.init();
        Sailing.register((String)"Time On Display", (String)"time_on_display", (String)"2.0.0", (String)"[1.21]", Constants.PUBLISHER_AUTHOR, Constants.PRIMARY_CURSEFORGE_MODRINTH);
        TimeOnDisplayConfig.initialize();
    }

    @Mod.EventBusSubscriber(modid="time_on_display", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class ModEvents {
        @SubscribeEvent
        public static void onKeyRegister(RegisterKeyMappingsEvent event) {
            event.register(TimeOnDisplayKeyBindForge.TIMEONDISPLAY_KEY);
        }
    }

    @Mod.EventBusSubscriber(modid="time_on_display", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.FORGE)
    public static class ClientForgeBusEvents {
        @SubscribeEvent
        public static void onKeyInput(InputEvent.Key event) {
            if (TimeOnDisplayKeyBindForge.TIMEONDISPLAY_KEY.consumeClick() && Minecraft.getInstance().player != null) {
                displayToggle = !displayToggle;
            }
        }
    }

    @Mod.EventBusSubscriber(modid="time_on_display", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class ClientModBusEvents {
        private static final Field LAYERS = ObfuscationReflectionHelper.findField(Gui.class, (String)"layers");

        @SubscribeEvent
        public static void clientInit(FMLClientSetupEvent event) {
            event.enqueueWork(() -> {
                Minecraft mc = Minecraft.getInstance();
                try {
                    LayeredDraw layers = (LayeredDraw)LAYERS.get(mc.gui);
                    layers.add((LayeredDraw.Layer)new TimeOnDisplayOverlayForge());
                }
                catch (IllegalAccessException e) {
                    System.out.println(e.getMessage());
                }
            });
        }
    }
}

