/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.spark.common.platform.serverconfig;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.LinkedList;
import java.util.Map;
import java.util.stream.Collectors;

public class ExcludedConfigFilter {
    private final Collection<String> pathsToExclude;

    public ExcludedConfigFilter(Collection<String> pathsToExclude) {
        this.pathsToExclude = pathsToExclude;
    }

    public JsonElement apply(JsonElement json) {
        for (String path : this.pathsToExclude) {
            LinkedList<String> pathDeque = new LinkedList<String>(Arrays.asList(path.split("\\.")));
            ExcludedConfigFilter.delete(json, pathDeque);
        }
        return json;
    }

    private static void delete(JsonElement json, Deque<String> path) {
        Collection<Object> keys;
        if (path.isEmpty()) {
            return;
        }
        if (!json.isJsonObject()) {
            return;
        }
        JsonObject jsonObject = json.getAsJsonObject();
        String expected = path.removeFirst().replace("<dot>", ".");
        if (expected.equals("*")) {
            keys = jsonObject.entrySet().stream().map(Map.Entry::getKey).collect(Collectors.toList());
        } else if (expected.endsWith("*")) {
            String pattern = expected.substring(0, expected.length() - 1);
            keys = jsonObject.entrySet().stream().map(Map.Entry::getKey).filter(key -> key.startsWith(pattern)).collect(Collectors.toList());
        } else {
            keys = jsonObject.has(expected) ? Collections.singletonList(expected) : Collections.emptyList();
        }
        for (String key2 : keys) {
            if (path.isEmpty()) {
                jsonObject.remove(key2);
                continue;
            }
            LinkedList<String> pathCopy = keys.size() > 1 ? new LinkedList<String>(path) : path;
            ExcludedConfigFilter.delete(jsonObject.get(key2), pathCopy);
        }
    }
}

