/*
 * Decompiled with CFR 0.152.
 */
package net.smileycorp.atlas.api.block;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.smileycorp.atlas.common.Constants;

public class ShapedBlock {
    protected final String name;
    protected final Supplier<CreativeModeTab> tab;
    protected final Map<BlockShape, DeferredHolder<Block, Block>> BLOCKS = Maps.newHashMap();

    public ShapedBlock(String name, Supplier<CreativeModeTab> tab, BlockBehaviour.Properties properties, DeferredRegister<Item> items, DeferredRegister<Block> blocks, boolean hasWall) {
        this.name = name;
        this.tab = tab;
        this.register(items, blocks, () -> new Block(properties), BlockShape.BASE);
        this.register(items, blocks, () -> new StairBlock(this.getBase().defaultBlockState(), properties), BlockShape.STAIRS);
        this.register(items, blocks, () -> new SlabBlock(properties), BlockShape.SLAB);
        if (hasWall) {
            this.register(items, blocks, () -> new WallBlock(properties), BlockShape.WALL);
        }
        Constants.MOD_BUS.register((Object)this);
    }

    protected void register(DeferredRegister<Item> items, DeferredRegister<Block> blocks, Supplier<Block> supplier, BlockShape shape) {
        Object name = this.name;
        if (shape != BlockShape.BASE) {
            name = (String)name + "_" + shape.getSerializedName();
        }
        DeferredHolder block = blocks.register((String)name, supplier);
        items.register((String)name, () -> new BlockItem((Block)block.get(), new Item.Properties()));
        this.BLOCKS.put(shape, (DeferredHolder<Block, Block>)block);
    }

    @SubscribeEvent
    public void addCreative(BuildCreativeModeTabContentsEvent event) {
        if (event.getTab() == this.tab.get()) {
            event.accept((ItemLike)this.getBase().asItem());
            event.accept((ItemLike)this.getStairs().asItem());
            event.accept((ItemLike)this.getSlab().asItem());
            if (this.BLOCKS.containsKey((Object)BlockShape.WALL)) {
                event.accept((ItemLike)this.getWall().asItem());
            }
        }
    }

    public Block get(BlockShape shape) {
        return this.BLOCKS.containsKey((Object)shape) ? (Block)this.BLOCKS.get((Object)shape).get() : null;
    }

    public Block getBase() {
        return this.get(BlockShape.BASE);
    }

    public StairBlock getStairs() {
        return (StairBlock)this.get(BlockShape.STAIRS);
    }

    public SlabBlock getSlab() {
        return (SlabBlock)this.get(BlockShape.SLAB);
    }

    public WallBlock getWall() {
        return (WallBlock)this.get(BlockShape.WALL);
    }

    public static enum BlockShape implements StringRepresentable
    {
        BASE("base"),
        STAIRS("stairs"),
        SLAB("slab"),
        WALL("wall");

        private final String name;

        private BlockShape(String name) {
            this.name = name;
        }

        public String getSerializedName() {
            return this.name;
        }
    }
}

