/*
 * Decompiled with CFR 0.152.
 */
package net.smileycorp.atlas.api.client;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.client.model.pipeline.QuadBakingVertexConsumer;
import net.smileycorp.atlas.api.client.PlanarQuadRenderer;

public class RenderingUtils {
    public static List<BakedModel> replaceRegisteredModel(Map<ResourceLocation, BakedModel> map, ResourceLocation name, Function<BakedModel, BakedModel> function) {
        ArrayList models = Lists.newArrayList();
        for (Map.Entry<ResourceLocation, BakedModel> entry : map.entrySet()) {
            ResourceLocation loc = entry.getKey();
            if (!loc.getNamespace().equals(name.getNamespace()) || !loc.getPath().split("#")[0].equals(name.getPath())) continue;
            models.add(function.apply(entry.getValue()));
        }
        BakedModel model = function.apply(map.get(name));
        map.put(name, model);
        return models;
    }

    public static void renderCubeQuad(BufferBuilder buffer, double x, double y, double z, int layer, Color colour, TextureAtlasSprite texture, Level world, int luminance, BlockPos pos) {
        for (Direction facing : Direction.values()) {
            RenderingUtils.renderPlanarQuad(buffer, facing, x, y, z, layer, colour, texture, world, luminance, pos);
        }
    }

    public static void renderPlanarQuad(BufferBuilder buffer, Direction facing, double x, double y, double z, int layer, Color colour, TextureAtlasSprite texture, Level world, int luminance, BlockPos pos) {
        Vec3[] plane = PlanarQuadRenderer.getQuadsFor(facing);
        Vec3 offset = layer == 0 ? new Vec3(0.0, 0.0, 0.0) : PlanarQuadRenderer.getOffsetFor(facing, x, y, z, layer);
        int rgba = colour.getRGB();
        for (int i = 0; i < 4; ++i) {
            Vec3 quadPos = plane[i];
            float r = (float)((rgba & 0xFF0000) >> 16) / 255.0f;
            float g = (float)((rgba & 0xFF00) >> 8) / 255.0f;
            float b = (float)(rgba & 0xFF) / 255.0f;
            float a = (float)((rgba & 0xFF000000) >> 24) / 255.0f;
            float u = i < 2 ? texture.getU1() - 6.25E-6f : texture.getU0() + 6.25E-6f;
            float v = i == 1 || i == 2 ? texture.getV1() - 6.25E-6f : texture.getV0() + 6.25E-6f;
            buffer.addVertex((float)(quadPos.x() + offset.x()), (float)(quadPos.y() + offset.y()), (float)(quadPos.z() + offset.z())).setColor(r, g, b, a).setUv(u, v);
        }
    }

    public static List<BakedQuad> getQuadsForCube(Color colour, TextureAtlasSprite sprite) {
        ArrayList quads = Lists.newArrayList();
        for (Direction facing : Direction.values()) {
            quads.addAll(RenderingUtils.getQuadsForPlane(facing, colour, sprite));
        }
        return quads;
    }

    public static List<BakedQuad> getQuadsForPlane(Direction facing, Color colour, TextureAtlasSprite sprite) {
        return RenderingUtils.getQuadsForPlane(facing, colour, sprite, 0);
    }

    public static List<BakedQuad> getQuadsForPlane(Direction facing, Color colour, TextureAtlasSprite sprite, int layer) {
        ArrayList quads = Lists.newArrayList();
        Vec3[] vecs = PlanarQuadRenderer.getQuadsFor(facing);
        QuadBakingVertexConsumer builder = new QuadBakingVertexConsumer();
        builder.setSprite(sprite);
        builder.setDirection(facing);
        Vec3 normal = new Vec3(vecs[2].x() - vecs[1].x(), vecs[2].y() - vecs[1].y(), vecs[2].z() - vecs[1].z());
        normal.cross(new Vec3(vecs[0].x() - vecs[1].x(), vecs[0].y() - vecs[1].y(), vecs[0].z() - vecs[1].z()));
        normal.normalize();
        RenderingUtils.addVertex((VertexConsumer)builder, (float)vecs[0].x(), (float)vecs[0].y(), (float)vecs[0].z(), 0.0f, 0.0f, normal, colour, sprite);
        RenderingUtils.addVertex((VertexConsumer)builder, (float)vecs[1].x(), (float)vecs[1].y(), (float)vecs[1].z(), 0.0f, sprite.getY(), normal, colour, sprite);
        RenderingUtils.addVertex((VertexConsumer)builder, (float)vecs[2].x(), (float)vecs[2].y(), (float)vecs[2].z(), sprite.getX(), sprite.getY(), normal, colour, sprite);
        RenderingUtils.addVertex((VertexConsumer)builder, (float)vecs[3].x(), (float)vecs[3].y(), (float)vecs[3].z(), sprite.getX(), 0.0f, normal, colour, sprite);
        return quads;
    }

    private static void addVertex(VertexConsumer builder, float x, float y, float z, float u, float v, Vec3 normal, Color colour, TextureAtlasSprite sprite) {
        builder.addVertex(x, y, z).setUv(u, v).setUv2(0, 0).setColor(colour.getRed(), colour.getGreen(), colour.getBlue(), colour.getAlpha()).setNormal((float)normal.x(), (float)normal.y(), (float)normal.z());
    }

    public static void drawText(PoseStack stack, Component text, float x, float y, int colour, boolean hasShadow) {
        Minecraft mc = Minecraft.getInstance();
        mc.font.drawInBatch(text, x, y, colour, hasShadow, stack.last().pose(), (MultiBufferSource)mc.renderBuffers().bufferSource(), Font.DisplayMode.NORMAL, 0, 0xF000F0);
    }

    public static void drawText(PoseStack stack, String text, float x, float y, int colour, boolean hasShadow) {
        Minecraft mc = Minecraft.getInstance();
        mc.font.drawInBatch(text, x, y, colour, hasShadow, stack.last().pose(), (MultiBufferSource)mc.renderBuffers().bufferSource(), Font.DisplayMode.NORMAL, 0, 0xF000F0);
    }
}

