/*
 * Decompiled with CFR 0.152.
 */
package net.smileycorp.atlas.api.entity.ai;

import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.level.pathfinder.PathType;

public class GoToPositionGoal
extends Goal {
    protected final Mob entity;
    protected BlockPos pos;
    protected final PathNavigation pather;
    protected final double speed;
    protected int timeToRecalcPath = 0;
    protected float waterCost;

    public GoToPositionGoal(Mob entity, BlockPos pos) {
        this(entity, pos, 1.0);
    }

    public GoToPositionGoal(Mob entity, BlockPos pos, double speed) {
        this.entity = entity;
        this.pos = pos;
        this.pather = entity.getNavigation();
        this.speed = speed;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean canUse() {
        return true;
    }

    public void start() {
        this.waterCost = this.entity.getPathfindingMalus(PathType.WATER);
    }

    public boolean canContinueToUse() {
        return true;
    }

    public void stop() {
        this.pather.stop();
        this.entity.setPathfindingMalus(PathType.WATER, this.waterCost);
    }

    public void tick() {
        if (--this.timeToRecalcPath <= 0) {
            this.timeToRecalcPath = 10;
            this.pather.moveTo(this.pather.createPath(this.pos, 1), this.speed);
        }
    }
}

