/*
 * Decompiled with CFR 0.152.
 */
package net.smileycorp.atlas.api.network;

import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.smileycorp.atlas.api.network.GenericMessage;
import net.smileycorp.atlas.api.util.TextUtils;

public class GenericTranslatableMessage
extends GenericMessage {
    private String key;
    private String fallback;
    private Object[] args = new Object[0];

    public GenericTranslatableMessage(CustomPacketPayload.Type<? extends GenericTranslatableMessage> type) {
        super(type);
    }

    public GenericTranslatableMessage(TranslatableContents contents, CustomPacketPayload.Type<? extends GenericTranslatableMessage> type) {
        super(type);
        this.key = contents.getKey();
        this.fallback = contents.getFallback();
        this.args = contents.getArgs();
    }

    public GenericTranslatableMessage(CustomPacketPayload.Type<? extends GenericTranslatableMessage> type, String key, String fallback, Object ... args) {
        super(type);
        this.key = key;
        this.fallback = fallback;
        this.args = args;
    }

    public MutableComponent getComponent() {
        return TextUtils.translatableComponent(this.key, this.fallback, this.args);
    }

    @Override
    public void write(FriendlyByteBuf buf) {
        buf.writeUtf(this.key);
        buf.writeUtf(this.fallback);
        buf.writeInt(this.args.length);
        for (Object arg : this.args) {
            buf.writeUtf(String.valueOf(arg));
        }
    }

    @Override
    public void read(FriendlyByteBuf buf) {
        this.key = buf.readUtf();
        this.fallback = buf.readUtf();
        this.args = new String[buf.readInt()];
        for (int i = 0; i < this.args.length; ++i) {
            this.args[i] = buf.readUtf();
        }
    }

    @Override
    public void process(IPayloadContext ctx) {
        throw new IllegalArgumentException("Please use the other register method, when using generic messages!");
    }
}

