/*
 * Decompiled with CFR 0.152.
 */
package net.smileycorp.atlas.api.util;

import java.util.List;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.world.item.ItemStack;

public class RecipeUtils {
    public static boolean compareItemStacks(ItemStack stack1, ItemStack stack2, boolean useNBT) {
        if (stack1 == null || stack2 == null) {
            return false;
        }
        if (stack2.getItem() == stack1.getItem() && stack2.getDamageValue() == stack1.getDamageValue()) {
            DataComponentMap nbt1 = stack1.getComponents();
            DataComponentMap nbt2 = stack2.getComponents();
            if (nbt1 == null || nbt2 == null) {
                return nbt1 == nbt2;
            }
            return nbt1.equals((Object)nbt2) || !useNBT;
        }
        return false;
    }

    public static boolean compareItemStacksCanFit(ItemStack stack1, ItemStack stack2) {
        if (stack1.isEmpty() || stack2.isEmpty()) {
            return true;
        }
        return RecipeUtils.compareItemStacks(stack1, stack2, true) && stack1.getCount() + stack2.getCount() <= stack1.getMaxStackSize();
    }

    public static boolean compareItemStacksWithSize(ItemStack stack1, ItemStack stack2, boolean matchExactly) {
        return RecipeUtils.compareItemStacks(stack1, stack2, true) && (stack1.getCount() == stack2.getCount() || !matchExactly && stack1.getCount() < stack2.getCount());
    }

    public static boolean canResultsFitInSlots(List<ItemStack> outputList, List<ItemStack> slots, int amount) {
        for (ItemStack out : outputList) {
            amount = RecipeUtils.compareSlots(out, slots, amount);
            if (amount > 0) continue;
            return true;
        }
        return false;
    }

    private static int compareSlots(ItemStack out, List<ItemStack> slots, int amount) {
        for (ItemStack slot : slots) {
            if (!RecipeUtils.compareItemStacksCanFit(out, slot)) continue;
            return amount--;
        }
        for (ItemStack slot : slots) {
            if (!slot.isEmpty()) continue;
            return amount--;
        }
        return amount;
    }
}

