/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.u_team_core.api.network;

import info.u_team.u_team_core.api.network.NetworkContext;
import info.u_team.u_team_core.api.network.NetworkHandlerEnvironment;
import info.u_team.u_team_core.api.network.NetworkMessage;
import info.u_team.u_team_core.api.network.NetworkPayload;
import info.u_team.u_team_core.util.ServiceUtil;
import java.util.function.BiConsumer;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;

public interface NetworkHandler {
    public static NetworkHandler create(ResourceLocation channel, int protocolVersion) {
        return Factory.INSTANCE.create(channel, protocolVersion);
    }

    default public <M> NetworkMessage<M> register(int id, NetworkHandlerEnvironment handlerEnvironment, StreamCodec<? super RegistryFriendlyByteBuf, M> streamCodec, BiConsumer<M, NetworkContext> handler) {
        return this.register(id, NetworkPayload.of(handlerEnvironment, streamCodec, handler));
    }

    default public <M> NetworkMessage<M> register(int index, NetworkPayload<M> payload) {
        return this.register(Integer.toString(index), payload);
    }

    default public <M> NetworkMessage<M> register(String id, NetworkHandlerEnvironment handlerEnvironment, StreamCodec<? super RegistryFriendlyByteBuf, M> streamCodec, BiConsumer<M, NetworkContext> handler) {
        return this.register(id, NetworkPayload.of(handlerEnvironment, streamCodec, handler));
    }

    public <M> NetworkMessage<M> register(String var1, NetworkPayload<M> var2);

    public void register();

    public ResourceLocation getNetworkId();

    public int getProtocolVersion();

    public static interface Factory {
        public static final Factory INSTANCE = ServiceUtil.loadOne(Factory.class);

        public NetworkHandler create(ResourceLocation var1, int var2);
    }
}

