/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.u_team_core.data;

import com.google.gson.JsonElement;
import com.mojang.serialization.Codec;
import info.u_team.u_team_core.data.GenerationData;
import java.nio.file.Path;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;

public interface CommonDataProvider<V>
extends DataProvider {
    public GenerationData getGenerationData();

    default public String modid() {
        return this.getGenerationData().modid();
    }

    default public String nameSuffix() {
        StringBuilder builder = new StringBuilder(this.modid());
        if (!this.getGenerationData().nameSuffix().isEmpty()) {
            builder.append(" (");
            builder.append(this.getGenerationData().nameSuffix());
            builder.append(")");
        }
        return builder.toString();
    }

    default public <U> CompletableFuture<U> withRegistries(Function<HolderLookup.Provider, ? extends CompletionStage<U>> function) {
        return this.getGenerationData().registriesFuture().thenCompose(function);
    }

    public void register(V var1);

    default public <T> CompletableFuture<?> saveData(CachedOutput cachedOutput, HolderLookup.Provider registries, Codec<T> codec, T value, Path path) {
        return DataProvider.saveStable((CachedOutput)cachedOutput, (HolderLookup.Provider)registries, codec, value, (Path)path);
    }

    default public CompletableFuture<?> saveData(CachedOutput cachedOutput, JsonElement json, Path path) {
        return DataProvider.saveStable((CachedOutput)cachedOutput, (JsonElement)json, (Path)path);
    }

    public static interface NoParam
    extends CommonDataProvider<Void> {
        @Override
        default public void register(Void data) {
            this.register();
        }

        public void register();
    }
}

