/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.u_team_core.impl;

import info.u_team.u_team_core.api.event.CommonEvents;
import info.u_team.u_team_core.util.registry.BusRegister;
import java.util.function.Consumer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.neoforged.bus.api.Event;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.event.level.LevelEvent;
import net.neoforged.neoforge.event.tick.LevelTickEvent;
import net.neoforged.neoforge.event.tick.ServerTickEvent;
import net.neoforged.neoforge.registries.RegisterEvent;

public class NeoForgeCommonEventsHandler
implements CommonEvents.Handler {
    @Override
    public void registerSetup(CommonEvents.SetupEvent event, boolean forceMainThread) {
        this.registerModEvent(FMLCommonSetupEvent.class, modEvent -> {
            if (forceMainThread) {
                modEvent.enqueueWork(event::onSetup);
            } else {
                event.onSetup();
            }
        });
    }

    @Override
    public void registerRegister(CommonEvents.RegisterEvent event) {
        this.registerModEvent(RegisterEvent.class, modEvent -> event.onRegister(modEvent.getRegistryKey()));
    }

    @Override
    public void registerStartServerTick(CommonEvents.StartServerTick event) {
        this.registerNeoForgeEvent(ServerTickEvent.Pre.class, forgeEvent -> event.onStartTick(forgeEvent.getServer()));
    }

    @Override
    public void registerEndServerTick(CommonEvents.EndServerTick event) {
        this.registerNeoForgeEvent(ServerTickEvent.Post.class, forgeEvent -> event.onEndTick(forgeEvent.getServer()));
    }

    @Override
    public void registerStartLevelTick(CommonEvents.StartLevelTick event) {
        this.registerNeoForgeEvent(LevelTickEvent.Pre.class, forgeEvent -> {
            Level patt0$temp = forgeEvent.getLevel();
            if (patt0$temp instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)patt0$temp;
                event.onStartTick(serverLevel);
            }
        });
    }

    @Override
    public void registerEndLevelTick(CommonEvents.EndLevelTick event) {
        this.registerNeoForgeEvent(LevelTickEvent.Post.class, forgeEvent -> {
            Level patt0$temp = forgeEvent.getLevel();
            if (patt0$temp instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)patt0$temp;
                event.onEndTick(serverLevel);
            }
        });
    }

    @Override
    public void registerLevelLoad(CommonEvents.LevelLoad event) {
        this.registerNeoForgeEvent(LevelEvent.Load.class, forgeEvent -> {
            LevelAccessor patt0$temp = forgeEvent.getLevel();
            if (patt0$temp instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)patt0$temp;
                event.onLoad(serverLevel);
            }
        });
    }

    @Override
    public void registerLevelUnload(CommonEvents.LevelUnload event) {
        this.registerNeoForgeEvent(LevelEvent.Unload.class, forgeEvent -> {
            LevelAccessor patt0$temp = forgeEvent.getLevel();
            if (patt0$temp instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)patt0$temp;
                event.onUnload(serverLevel);
            }
        });
    }

    private <T extends Event> void registerModEvent(Class<T> eventClass, Consumer<T> event) {
        BusRegister.registerMod(bus -> bus.addListener(EventPriority.NORMAL, false, eventClass, event));
    }

    private <T extends Event> void registerNeoForgeEvent(Class<T> eventClass, Consumer<T> event) {
        BusRegister.registerNeoForge(bus -> bus.addListener(EventPriority.NORMAL, false, eventClass, event));
    }
}

