/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.u_team_core.impl;

import info.u_team.u_team_core.api.network.NetworkContext;
import info.u_team.u_team_core.api.network.NetworkEnvironment;
import info.u_team.u_team_core.api.network.NetworkHandler;
import info.u_team.u_team_core.api.network.NetworkHandlerEnvironment;
import info.u_team.u_team_core.impl.common.CommonNetworkHandler;
import info.u_team.u_team_core.util.registry.BusRegister;
import java.util.concurrent.CompletableFuture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.neoforged.fml.LogicalSide;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.neoforged.neoforge.network.handling.IPayloadHandler;
import net.neoforged.neoforge.network.registration.HandlerThread;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;

public class NeoForgeNetworkHandler
extends CommonNetworkHandler {
    NeoForgeNetworkHandler(ResourceLocation networkId, int protocolVersion) {
        super(networkId, protocolVersion);
    }

    @Override
    public void register() {
        BusRegister.registerMod(bus -> bus.addListener(this::registerPayloadHandlers));
    }

    private void registerPayloadHandlers(RegisterPayloadHandlersEvent event) {
        PayloadRegistrar registrar = event.registrar(Integer.toString(this.protocolVersion)).optional().executesOn(HandlerThread.NETWORK);
        for (CommonNetworkHandler.MessagePacketPayload messagePayload : this.messages.values()) {
            NetworkHandlerEnvironment environment = messagePayload.payload().handlerEnvironment();
            IPayloadHandler handler = (payload, context) -> messagePayload.handle(payload, (NetworkContext)new NeoForgeNetworkContext(messagePayload, context));
            if (environment == NetworkHandlerEnvironment.CLIENT) {
                registrar.playToClient(messagePayload.type(), messagePayload.streamCodec(), handler);
                continue;
            }
            if (environment == NetworkHandlerEnvironment.SERVER) {
                registrar.playToServer(messagePayload.type(), messagePayload.streamCodec(), handler);
                continue;
            }
            if (environment != NetworkHandlerEnvironment.BOTH) continue;
            registrar.playBidirectional(messagePayload.type(), messagePayload.streamCodec(), handler);
        }
    }

    private static class NeoForgeNetworkContext<M>
    extends CommonNetworkHandler.CommonNetworkContext<M> {
        private final IPayloadContext context;

        private NeoForgeNetworkContext(CommonNetworkHandler.MessagePacketPayload<M> messagePayload, IPayloadContext context) {
            super(messagePayload);
            this.context = context;
        }

        @Override
        public NetworkEnvironment getEnvironment() {
            return switch (this.context.flow().getReceptionSide()) {
                default -> throw new MatchException(null, null);
                case LogicalSide.CLIENT -> NetworkEnvironment.CLIENT;
                case LogicalSide.SERVER -> NetworkEnvironment.SERVER;
            };
        }

        @Override
        public Player getPlayer() {
            return this.context.player();
        }

        @Override
        protected CompletableFuture<Void> execute(Runnable runnable) {
            return this.context.enqueueWork(runnable);
        }
    }

    public static class Factory
    implements NetworkHandler.Factory {
        @Override
        public NetworkHandler create(ResourceLocation channel, int protocolVersion) {
            return new NeoForgeNetworkHandler(channel, protocolVersion);
        }
    }
}

