/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.u_team_core.intern.network;

import info.u_team.u_team_core.api.network.NetworkContext;
import info.u_team.u_team_core.menutype.UMenuType;
import info.u_team.u_team_core.util.CastUtil;
import info.u_team.u_team_core.util.RegistryUtil;
import io.netty.buffer.Unpooled;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.MenuAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.MenuType;

public record OpenMenuScreenMessage(int containerId, MenuType<?> type, Component title, byte[] extraData) {
    public static final StreamCodec<RegistryFriendlyByteBuf, OpenMenuScreenMessage> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_INT, OpenMenuScreenMessage::containerId, (StreamCodec)ByteBufCodecs.registry((ResourceKey)Registries.MENU), OpenMenuScreenMessage::type, (StreamCodec)ComponentSerialization.TRUSTED_STREAM_CODEC, OpenMenuScreenMessage::title, (StreamCodec)ByteBufCodecs.BYTE_ARRAY, OpenMenuScreenMessage::extraData, OpenMenuScreenMessage::new);

    public static void handle(OpenMenuScreenMessage message, NetworkContext context) {
        context.executeOnMainThread(() -> {
            Minecraft minecraft = Minecraft.getInstance();
            Inventory playerInventory = minecraft.player.getInventory();
            int containerId = message.containerId;
            MenuType<?> type = message.type;
            Component title = message.title;
            FriendlyByteBuf extraData = new FriendlyByteBuf(Unpooled.wrappedBuffer((byte[])message.extraData));
            try {
                Object menu;
                if (message.type == null) {
                    MenuScreens.LOGGER.warn("Trying to open invalid screen with name: {}", (Object)title.getString());
                    return;
                }
                MenuScreens.ScreenConstructor constructor = (MenuScreens.ScreenConstructor)CastUtil.uncheckedCast(MenuScreens.getConstructor(type));
                if (constructor == null) {
                    MenuScreens.LOGGER.warn("Failed to create screen for menu type: {}", (Object)RegistryUtil.getBuiltInRegistry(Registries.MENU).getKey(type));
                    return;
                }
                if (type instanceof UMenuType) {
                    UMenuType uType = (UMenuType)type;
                    menu = uType.createWithExtraData(containerId, playerInventory, extraData);
                } else {
                    menu = type.create(containerId, playerInventory);
                }
                Screen screen = constructor.create(menu, playerInventory, title);
                if (!(screen instanceof MenuAccess)) {
                    MenuScreens.LOGGER.warn("Trying to open invalid screen that does not implement MenuAccess with name: {}", (Object)title.getString());
                    return;
                }
                MenuAccess menuAccess = (MenuAccess)screen;
                minecraft.player.containerMenu = menuAccess.getMenu();
                minecraft.setScreen(screen);
            }
            finally {
                extraData.release();
            }
        });
    }
}

