/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.u_team_core.menu;

import info.u_team.u_team_core.api.Platform;
import info.u_team.u_team_core.api.block.MenuSyncedBlockEntity;
import info.u_team.u_team_core.api.network.NetworkEnvironment;
import info.u_team.u_team_core.menu.UContainerMenu;
import info.u_team.u_team_core.util.CastUtil;
import info.u_team.u_team_core.util.EnvironmentUtil;
import io.netty.buffer.Unpooled;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.level.block.entity.BlockEntity;

public abstract class UBlockEntityContainerMenu<T extends BlockEntity>
extends UContainerMenu {
    protected final Inventory playerInventory;
    protected final T blockEntity;

    public UBlockEntityContainerMenu(MenuType<?> menuType, int containerId, Inventory playerInventory, T blockEntity) {
        this(menuType, containerId, playerInventory, blockEntity, true);
    }

    public UBlockEntityContainerMenu(MenuType<?> menuType, int containerId, Inventory playerInventory, T blockEntity, boolean callInit) {
        super(menuType, containerId);
        this.playerInventory = playerInventory;
        this.blockEntity = blockEntity;
        if (callInit) {
            this.init(NetworkEnvironment.SERVER);
        }
    }

    public UBlockEntityContainerMenu(MenuType<?> menuType, int containerId, Inventory playerInventory, FriendlyByteBuf buffer) {
        this(menuType, containerId, playerInventory, buffer, true);
    }

    public UBlockEntityContainerMenu(MenuType<?> menuType, int containerId, Inventory playerInventory, FriendlyByteBuf buffer, boolean callInit) {
        super(menuType, containerId);
        this.playerInventory = playerInventory;
        T t = this.blockEntity = (BlockEntity)EnvironmentUtil.callWhen(Platform.Environment.CLIENT, () -> () -> Client.getClientBlockEntity(buffer));
        if (t instanceof MenuSyncedBlockEntity) {
            MenuSyncedBlockEntity syncedBlockEntity = (MenuSyncedBlockEntity)t;
            FriendlyByteBuf data = new FriendlyByteBuf(Unpooled.wrappedBuffer((byte[])buffer.readByteArray(32592)));
            syncedBlockEntity.handleInitialMenuDataFromServer(data);
            data.release();
        }
        if (callInit) {
            this.init(NetworkEnvironment.CLIENT);
        }
    }

    protected abstract void init(NetworkEnvironment var1);

    public T getBlockEntity() {
        return this.blockEntity;
    }

    private static class Client {
        private Client() {
        }

        private static <T extends BlockEntity> T getClientBlockEntity(FriendlyByteBuf buffer) {
            BlockPos pos = buffer.readBlockPos();
            BlockEntity blockEntity = Minecraft.getInstance().level.getBlockEntity(pos);
            if (blockEntity == null) {
                throw new IllegalStateException("The client block entity at (" + pos.toShortString() + ") does not exist.");
            }
            return (T)((BlockEntity)CastUtil.uncheckedCast(blockEntity));
        }
    }
}

