/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.u_team_core.util;

import java.util.Random;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.PositionalRandomFactory;
import net.minecraft.world.phys.Vec3;

public class MathUtil {
    public static final RandomSource RANDOM = RandomSource.create();

    public static Vec3 rotateVectorAroundYCC(Vec3 vec, double angle) {
        return MathUtil.rotateVectorCC(vec, new Vec3(0.0, 1.0, 0.0), angle);
    }

    public static Vec3 rotateVectorCC(Vec3 vec, Vec3 axis, double angle) {
        double x = vec.x();
        double y = vec.y();
        double z = vec.z();
        double u = axis.x();
        double v = axis.y();
        double w = axis.z();
        double rotationX = u * (u * x + v * y + w * z) * (1.0 - Math.cos(angle)) + x * Math.cos(angle) + (-w * y + v * z) * Math.sin(angle);
        double rotationY = v * (u * x + v * y + w * z) * (1.0 - Math.cos(angle)) + y * Math.cos(angle) + (w * x - u * z) * Math.sin(angle);
        double rotationZ = w * (u * x + v * y + w * z) * (1.0 - Math.cos(angle)) + z * Math.cos(angle) + (-v * x + u * y) * Math.sin(angle);
        return new Vec3(rotationX, rotationY, rotationZ);
    }

    public static int randomNumberInRange(int min, int max) {
        return MathUtil.randomNumberInRange(RANDOM, min, max);
    }

    public static int randomNumberInRange(RandomSource random, int min, int max) {
        return random.nextInt(max - min + 1) + min;
    }

    public static float randomNumberInRange(float min, float max) {
        return MathUtil.randomNumberInRange(RANDOM, min, max);
    }

    public static float randomNumberInRange(RandomSource random, float min, float max) {
        return random.nextFloat() * (max - min) + min;
    }

    public static double randomNumberInRange(double min, double max) {
        return MathUtil.randomNumberInRange(RANDOM, min, max);
    }

    public static double randomNumberInRange(RandomSource random, double min, double max) {
        return random.nextDouble() * (max - min) + min;
    }

    public static int valueInRange(int min, int max, int value) {
        return Math.min(max, Math.max(min, value));
    }

    public static long valueInRange(long min, long max, long value) {
        return Math.min(max, Math.max(min, value));
    }

    public static float valueInRange(float min, float max, float value) {
        return Math.min(max, Math.max(min, value));
    }

    public static double valueInRange(double min, double max, double value) {
        return Math.min(max, Math.max(min, value));
    }

    public static float getPlaneDistance(int x1, int z1, int x2, int z2) {
        int xDiff = x2 - x1;
        int zDiff = z2 - z1;
        return Mth.sqrt((float)(xDiff * xDiff + zDiff * zDiff));
    }

    public record RandomSourceWrapper(Random random) implements RandomSource
    {
        public RandomSource fork() {
            return new LegacyRandomSource(this.nextLong());
        }

        public PositionalRandomFactory forkPositional() {
            return new LegacyRandomSource.LegacyPositionalRandomFactory(this.nextLong());
        }

        public void setSeed(long seed) {
            this.random.setSeed(seed);
        }

        public int nextInt() {
            return this.random.nextInt();
        }

        public int nextInt(int bound) {
            return this.random.nextInt(bound);
        }

        public long nextLong() {
            return this.random.nextLong();
        }

        public boolean nextBoolean() {
            return this.random.nextBoolean();
        }

        public float nextFloat() {
            return this.random.nextFloat();
        }

        public double nextDouble() {
            return this.random.nextDouble();
        }

        public double nextGaussian() {
            return this.random.nextGaussian();
        }
    }
}

