/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.u_team_core.util;

import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.ClientboundCustomPayloadPacket;
import net.minecraft.network.protocol.common.ServerboundCustomPayloadPacket;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.protocol.game.ClientboundBundlePacket;
import net.minecraft.server.level.ServerPlayer;

public class NetworkUtil {
    public static ClientboundCustomPayloadPacket createClientBoundPacket(CustomPacketPayload payload) {
        return new ClientboundCustomPayloadPacket(payload);
    }

    public static Packet<?> createClientBoundBundlePacket(CustomPacketPayload mainPayload, CustomPacketPayload ... payloads) {
        if (payloads.length == 0) {
            return NetworkUtil.createClientBoundPacket(mainPayload);
        }
        ArrayList<ClientboundCustomPayloadPacket> packets = new ArrayList<ClientboundCustomPayloadPacket>();
        packets.add(NetworkUtil.createClientBoundPacket(mainPayload));
        for (CustomPacketPayload payload : payloads) {
            packets.add(NetworkUtil.createClientBoundPacket(payload));
        }
        return new ClientboundBundlePacket(packets);
    }

    public static ServerboundCustomPayloadPacket createServerBoundPacket(CustomPacketPayload payload) {
        return new ServerboundCustomPayloadPacket(payload);
    }

    public static void sendToPlayer(ServerPlayer player, CustomPacketPayload mainPayload, CustomPacketPayload ... payloads) {
        NetworkUtil.sendToPlayer(player, NetworkUtil.createClientBoundBundlePacket(mainPayload, payloads));
    }

    public static void sendToPlayer(ServerPlayer player, Packet<?> packet) {
        player.connection.send(packet);
    }

    public static void sendToConnection(Connection connection, CustomPacketPayload mainPayload, CustomPacketPayload ... payloads) {
        NetworkUtil.sendToConnection(connection, NetworkUtil.createClientBoundBundlePacket(mainPayload, payloads));
    }

    public static void sendToConnection(Connection connection, Packet<?> packet) {
        connection.send(packet);
    }

    public static void sendToServer(CustomPacketPayload mainPayload, CustomPacketPayload ... payloads) {
        NetworkUtil.sendToServer(NetworkUtil.createServerBoundPacket(mainPayload));
        for (CustomPacketPayload payload : payloads) {
            NetworkUtil.sendToServer(NetworkUtil.createServerBoundPacket(payload));
        }
    }

    public static void sendToServer(Packet<?> packet) {
        Minecraft.getInstance().getConnection().send(packet);
    }
}

