/*
 * Decompiled with CFR 0.152.
 */
package dev.corgitaco.enhancedcelestials.client.render.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import dev.corgitaco.enhancedcelestials.EnhancedCelestials;
import dev.corgitaco.enhancedcelestials.entity.MeteorStrikeEntity;
import java.util.UUID;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import org.joml.Matrix4f;
import org.lwjgl.glfw.GLFW;

public class MeteorStrikeRenderer
extends EntityRenderer<MeteorStrikeEntity> {
    public static final ResourceLocation TEXTURE = EnhancedCelestials.createLocation("textures/entity/meteor_strike.png");

    public MeteorStrikeRenderer(EntityRendererProvider.Context $$0) {
        super($$0);
    }

    public void render(MeteorStrikeEntity meteorStrikeEntity, float yaw, float tickDelta, PoseStack matrices, MultiBufferSource vertexConsumers, int light) {
        super.render((Entity)meteorStrikeEntity, yaw, tickDelta, matrices, vertexConsumers, light);
        float width = meteorStrikeEntity.getBbWidth() / 2.0f;
        matrices.translate(0.0, 0.02, 0.0);
        UUID uuid = meteorStrikeEntity.getUUID();
        float rotation = (float)((GLFW.glfwGetTime() + (double)((int)uuid.getMostSignificantBits())) % 360.0);
        matrices.mulPose(Axis.YP.rotationDegrees(rotation * 25.0f));
        MeteorStrikeRenderer.renderPlaneTexture(matrices, vertexConsumers, width);
    }

    private static void renderPlaneTexture(PoseStack matrices, MultiBufferSource vertexConsumers, float width) {
        Matrix4f pose = matrices.last().pose();
        VertexConsumer buffer = vertexConsumers.getBuffer(RenderType.entityTranslucent((ResourceLocation)TEXTURE));
        buffer.addVertex(pose, -width, 0.0f, -width).setColor(255, 255, 255, 255).setUv(0.0f, 0.0f).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0).setNormal(matrices.last(), 0.0f, 0.0f, 1.0f);
        buffer.addVertex(pose, -width, 0.0f, width).setColor(255, 255, 255, 255).setUv(0.0f, 1.0f).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0).setNormal(matrices.last(), 0.0f, 0.0f, 1.0f);
        buffer.addVertex(pose, width, 0.0f, width).setColor(255, 255, 255, 255).setUv(1.0f, 1.0f).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0).setNormal(matrices.last(), 0.0f, 1.0f, 0.0f);
        buffer.addVertex(pose, width, 0.0f, -width).setColor(255, 255, 255, 255).setUv(1.0f, 0.0f).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0).setNormal(matrices.last(), 0.0f, 1.0f, 0.0f);
    }

    public ResourceLocation getTextureLocation(MeteorStrikeEntity meteorEntity) {
        return null;
    }

    protected boolean shouldShowName(MeteorStrikeEntity $$0) {
        return false;
    }
}

