/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.rewrite.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import mod.azure.azurelib.rewrite.model.AzBakedModel;
import mod.azure.azurelib.rewrite.render.AzLayerRenderer;
import mod.azure.azurelib.rewrite.render.AzModelRenderer;
import mod.azure.azurelib.rewrite.render.AzPhasedRenderer;
import mod.azure.azurelib.rewrite.render.AzRendererConfig;
import mod.azure.azurelib.rewrite.render.AzRendererPipelineContext;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import org.jetbrains.annotations.Nullable;

public abstract class AzRendererPipeline<T>
implements AzPhasedRenderer<T> {
    protected final AzRendererConfig<T> config;
    private final AzRendererPipelineContext<T> context;
    private final AzLayerRenderer<T> layerRenderer;
    private final AzModelRenderer<T> modelRenderer;

    protected AzRendererPipeline(AzRendererConfig<T> config) {
        this.config = config;
        this.context = this.createContext(this);
        this.layerRenderer = this.createLayerRenderer(config);
        this.modelRenderer = this.createModelRenderer(this.layerRenderer);
    }

    protected abstract AzRendererPipelineContext<T> createContext(AzRendererPipeline<T> var1);

    protected abstract AzModelRenderer<T> createModelRenderer(AzLayerRenderer<T> var1);

    protected abstract AzLayerRenderer<T> createLayerRenderer(AzRendererConfig<T> var1);

    protected abstract void updateAnimatedTextureFrame(T var1);

    public void render(PoseStack poseStack, AzBakedModel model, T animatable, MultiBufferSource bufferSource, @Nullable RenderType renderType, @Nullable VertexConsumer buffer, float yaw, float partialTick, int packedLight) {
        renderType = this.context.getDefaultRenderType(animatable, this.config.textureLocation(animatable), bufferSource, partialTick, this.config.getRenderType(animatable), this.config.alpha(animatable));
        this.context.populate(animatable, model, bufferSource, packedLight, partialTick, poseStack, renderType, buffer);
        poseStack.pushPose();
        this.preRender(this.context, false);
        this.layerRenderer.preApplyRenderLayers(this.context);
        this.modelRenderer.render(this.context, false);
        this.layerRenderer.applyRenderLayers(this.context);
        this.postRender(this.context, false);
        poseStack.popPose();
        this.renderFinal(this.context);
        this.doPostRenderCleanup(this.context);
    }

    public void reRender(AzRendererPipelineContext<T> context) {
        PoseStack poseStack = context.poseStack();
        poseStack.pushPose();
        this.preRender(context, true);
        this.modelRenderer.render(context, true);
        this.postRender(context, true);
        poseStack.popPose();
    }

    protected void renderFinal(AzRendererPipelineContext<T> context) {
    }

    protected void doPostRenderCleanup(AzRendererPipelineContext<T> context) {
    }

    protected void scaleModelForRender(AzRendererPipelineContext<T> context, float widthScale, float heightScale, boolean isReRender) {
        if (!(isReRender || widthScale == 1.0f && heightScale == 1.0f)) {
            PoseStack poseStack = context.poseStack();
            poseStack.scale(widthScale, heightScale, widthScale);
        }
    }

    public AzRendererConfig<T> config() {
        return this.config;
    }

    public AzRendererPipelineContext<T> context() {
        return this.context;
    }
}

