/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.rewrite.render.armor;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import mod.azure.azurelib.rewrite.animation.cache.AzIdentityRegistry;
import mod.azure.azurelib.rewrite.render.armor.AzArmorRenderer;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomModelData;
import org.jetbrains.annotations.Nullable;

public class AzArmorRendererRegistry {
    private static final Map<ArmorKey, AzArmorRenderer> ITEM_TO_RENDERER = new HashMap<ArmorKey, AzArmorRenderer>();
    private static final Map<ArmorKey, Supplier<AzArmorRenderer>> ITEM_TO_RENDERER_SUPPLIER = new HashMap<ArmorKey, Supplier<AzArmorRenderer>>();

    public static void register(Item item, Supplier<AzArmorRenderer> armorRendererSupplier) {
        AzArmorRendererRegistry.register(item, -1, armorRendererSupplier);
    }

    public static void register(Item item, int customModelData, Supplier<AzArmorRenderer> armorRendererSupplier) {
        ITEM_TO_RENDERER_SUPPLIER.put(new ArmorKey(item, customModelData), armorRendererSupplier);
        AzIdentityRegistry.register(item, new Item[0]);
    }

    public static void register(Supplier<AzArmorRenderer> armorRendererSupplier, Item item, Item ... items) {
        AzArmorRendererRegistry.register(item, armorRendererSupplier);
        for (Item otherItem : items) {
            AzArmorRendererRegistry.register(otherItem, armorRendererSupplier);
        }
    }

    public static void register(int customModelData, Supplier<AzArmorRenderer> armorRendererSupplier, Item item, Item ... items) {
        AzArmorRendererRegistry.register(item, customModelData, armorRendererSupplier);
        for (Item otherItem : items) {
            AzArmorRendererRegistry.register(otherItem, customModelData, armorRendererSupplier);
        }
    }

    @Nullable
    public static AzArmorRenderer getOrNull(Item item, int customModelData) {
        ArmorKey specificKey = new ArmorKey(item, customModelData);
        return ITEM_TO_RENDERER.computeIfAbsent(specificKey, key -> {
            Supplier<AzArmorRenderer> rendererSupplier = ITEM_TO_RENDERER_SUPPLIER.get(specificKey);
            if (rendererSupplier != null) {
                return rendererSupplier.get();
            }
            ArmorKey genericKey = new ArmorKey(item, -1);
            rendererSupplier = ITEM_TO_RENDERER_SUPPLIER.get(genericKey);
            return rendererSupplier != null ? rendererSupplier.get() : null;
        });
    }

    @Nullable
    public static AzArmorRenderer getOrNull(ItemStack stack) {
        int customModelData = AzArmorRendererRegistry.getCustomModelDataId(stack);
        return AzArmorRendererRegistry.getOrNull(stack.getItem(), customModelData);
    }

    public static int getCustomModelDataId(ItemStack itemStack) {
        int customModelDataId = 0;
        if (itemStack.getComponents().get(DataComponents.CUSTOM_MODEL_DATA) != null) {
            customModelDataId = ((CustomModelData)itemStack.getComponents().get(DataComponents.CUSTOM_MODEL_DATA)).value();
        }
        return customModelDataId;
    }

    private record ArmorKey(Item item, int customModelData) {
    }
}

