/*
 * Decompiled with CFR 0.152.
 */
package dev.uncandango.alltheleaks.leaks.common.mods.neoforge;

import com.mojang.datafixers.util.Pair;
import cpw.mods.jarhandling.impl.Jar;
import cpw.mods.jarhandling.impl.JarContentsImpl;
import cpw.mods.niofs.union.UnionFileSystem;
import cpw.mods.niofs.union.UnionFileSystemProvider;
import dev.uncandango.alltheleaks.AllTheLeaks;
import dev.uncandango.alltheleaks.annotation.Issue;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import net.neoforged.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.neoforged.fml.util.ObfuscationReflectionHelper;
import org.apache.commons.lang3.StringUtils;
import org.lwjgl.system.MemoryUtil;
import sun.misc.Unsafe;

@Issue(issueId="#289", modId="neoforge", versionRange="[21.,21.1.182]", description="Memory leak on FancyModLoader https://github.com/neoforged/FancyModLoader/issues/289")
public class Issue289 {
    public Issue289() {
        IEventBus modEventBus = ((ModContainer)ModList.get().getModContainerById("alltheleaks").get()).getEventBus();
        modEventBus.addListener(this::closeDanglingJars);
    }

    private void closeDanglingJars(FMLLoadCompleteEvent event) {
        event.enqueueWork(() -> {
            HashMap copyFileSystems = new HashMap();
            HashSet validFS = new HashSet();
            try {
                Unsafe UNSAFE = (Unsafe)ObfuscationReflectionHelper.getPrivateValue(MemoryUtil.class, null, (String)"UNSAFE");
                if (UNSAFE == null) {
                    throw new IllegalAccessException("Not possible to grab UNSAFE");
                }
                Field fieldImplLookup = MethodHandles.Lookup.class.getDeclaredField("IMPL_LOOKUP");
                MethodHandles.Lookup LOOKUP = (MethodHandles.Lookup)UNSAFE.getObject(UNSAFE.staticFieldBase(fieldImplLookup), UNSAFE.staticFieldOffset(fieldImplLookup));
                UnionFileSystemProvider UFSP = LOOKUP.findStaticVarHandle(JarContentsImpl.class, "UFSP", UnionFileSystemProvider.class).get();
                Map fileSystems = LOOKUP.findVarHandle(UnionFileSystemProvider.class, "fileSystems", Map.class).get(UFSP);
                copyFileSystems.putAll(fileSystems);
                VarHandle fsVH = LOOKUP.findVarHandle(Jar.class, "filesystem", UnionFileSystem.class);
                ModList.get().getModFiles().stream().map(modFile -> fsVH.get(modFile.getFile().getSecureJar())).forEach(validFS::add);
            }
            catch (Throwable e) {
                AllTheLeaks.LOGGER.error("Failed to clear dangling mod jars", e);
            }
            Pattern MATCH_PATTERN = Pattern.compile("(.*)#(\\d+)");
            HashMap<String, Pair> tempMap = new HashMap<String, Pair>();
            for (Map.Entry entry : copyFileSystems.entrySet()) {
                Integer newIndex;
                String newkey;
                Pair oldVal;
                String key = (String)entry.getKey();
                if (StringUtils.countMatches((CharSequence)key, (char)'#') > 1) continue;
                UnionFileSystem value = (UnionFileSystem)entry.getValue();
                Matcher match = MATCH_PATTERN.matcher(key);
                if (!match.find() || (oldVal = tempMap.put(newkey = match.group(1), Pair.of((Object)(newIndex = Integer.valueOf(match.group(2))), (Object)value))) == null) continue;
                if ((Integer)oldVal.getFirst() < newIndex) {
                    try {
                        if (validFS.contains(oldVal.getSecond())) {
                            AllTheLeaks.LOGGER.warn("Tried to release a valid jar {}#{}, skipping...", (Object)newkey, oldVal.getFirst());
                            continue;
                        }
                        AllTheLeaks.LOGGER.info("Releasing leaked jar: {}#{}", (Object)newkey, oldVal.getFirst());
                        ((UnionFileSystem)oldVal.getSecond()).close();
                    }
                    catch (IOException e) {
                        AllTheLeaks.LOGGER.error("Failed to close leaked jar.", (Throwable)e);
                    }
                    continue;
                }
                try {
                    if (validFS.contains(value)) {
                        AllTheLeaks.LOGGER.warn("Tried to release a valid jar {}#{}, skipping...", (Object)newkey, (Object)newIndex);
                        continue;
                    }
                    AllTheLeaks.LOGGER.info("Releasing leaked jar: {}#{}", (Object)newkey, (Object)newIndex);
                    value.close();
                }
                catch (IOException e) {
                    AllTheLeaks.LOGGER.error("Failed to close leaked jar.", (Throwable)e);
                }
            }
        });
    }
}

