/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.enchdesc.common.impl;

import java.util.function.Consumer;
import net.darkhax.bookshelf.common.api.service.Services;
import net.darkhax.enchdesc.common.api.ContextProvider;
import net.darkhax.enchdesc.common.impl.Config;
import net.darkhax.pricklemc.common.api.config.ConfigManager;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.EnchantmentScreen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import org.jetbrains.annotations.Nullable;

public class EnchdescMod {
    private static final String[] KEY_TYPES = new String[]{"desc", "description", "info"};
    private static EnchdescMod instance;
    private boolean hasInitialized = false;
    private Config config;

    public void init() {
        if (this.hasInitialized) {
            throw new IllegalStateException("The EnchantmentDescriptions has already been initialized.");
        }
        if (Services.PLATFORM.isPhysicalClient()) {
            this.config = (Config)ConfigManager.load((String)"enchdesc", (Object)new Config());
        }
        this.hasInitialized = true;
    }

    public void setupContext(ItemStack stack) {
        if (this.canDisplayDescription(stack) && this.isKeybindConditionMet()) {
            ContextProvider provider;
            Object object = stack.getEnchantments();
            if (object instanceof ContextProvider) {
                provider = (ContextProvider)object;
                provider.enchdesc$setStack(stack);
            }
            if ((object = stack.get(DataComponents.STORED_ENCHANTMENTS)) instanceof ContextProvider) {
                provider = (ContextProvider)object;
                provider.enchdesc$setStack(stack);
            }
        }
    }

    public void revertContext(ItemStack stack) {
        ContextProvider provider;
        Object object = stack.getEnchantments();
        if (object instanceof ContextProvider) {
            provider = (ContextProvider)object;
            provider.enchdesc$setStack(ItemStack.EMPTY);
        }
        if ((object = stack.get(DataComponents.STORED_ENCHANTMENTS)) instanceof ContextProvider) {
            provider = (ContextProvider)object;
            provider.enchdesc$setStack(ItemStack.EMPTY);
        }
    }

    public boolean canDisplayDescription(ItemStack stack) {
        return !(!this.hasInitialized || !this.config.enabled || !this.hasEnchantments(stack) || this.config.only_on_books && !(stack.getItem() instanceof EnchantedBookItem) || this.config.only_in_enchanting_table && !(Minecraft.getInstance().screen instanceof EnchantmentScreen));
    }

    public Component getKeybindText() {
        return this.config.activate_text;
    }

    public boolean isKeybindConditionMet() {
        return !this.config.require_keybind || Screen.hasShiftDown();
    }

    private boolean hasEnchantments(ItemStack stack) {
        return !((ItemEnchantments)stack.getOrDefault(DataComponents.ENCHANTMENTS, (Object)ItemEnchantments.EMPTY)).isEmpty() || !((ItemEnchantments)stack.getOrDefault(DataComponents.STORED_ENCHANTMENTS, (Object)ItemEnchantments.EMPTY)).isEmpty();
    }

    public void insertDescriptions(Holder<Enchantment> enchantment, int level, Consumer<Component> lines) {
        MutableComponent description = this.getDescription(enchantment, ((ResourceKey)enchantment.unwrapKey().orElseThrow()).location(), level);
        if (description != null) {
            ComponentUtils.mergeStyles((MutableComponent)description, (Style)this.config.style);
            lines.accept((Component)this.config.prefix.copy().append((Component)description).append(this.config.suffix));
        }
    }

    @Nullable
    private MutableComponent getDescription(Holder<Enchantment> enchantment, ResourceLocation id, int level) {
        ComponentContents componentContents;
        MutableComponent description = this.getDescription("enchantment." + id.getNamespace() + "." + id.getPath() + ".", level);
        if (description == null && (componentContents = ((Enchantment)enchantment.value()).description().getContents()) instanceof TranslatableContents) {
            TranslatableContents translatable = (TranslatableContents)componentContents;
            description = this.getDescription(translatable.getKey() + ".", level);
        }
        return description;
    }

    @Nullable
    private MutableComponent getDescription(String baseKey, int level) {
        for (String keyType : KEY_TYPES) {
            String key = baseKey + keyType;
            if (I18n.exists((String)key)) {
                return Component.translatable((String)key);
            }
            if (!I18n.exists((String)(key = key + "." + level))) continue;
            return Component.translatable((String)key);
        }
        return null;
    }

    public static EnchdescMod getInstance() {
        if (instance == null) {
            instance = new EnchdescMod();
        }
        return instance;
    }
}

