/*
 * Decompiled with CFR 0.152.
 */
package net.smileycorp.hordes.client.render;

import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import com.mojang.blaze3d.vertex.PoseStack;
import java.awt.Color;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.ZombieModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.HumanoidMobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.HumanoidArmorLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.monster.Zombie;
import net.smileycorp.atlas.api.client.PlayerTextureRenderer;
import net.smileycorp.hordes.client.render.ZombiePlayerCapeLayer;
import net.smileycorp.hordes.client.render.ZombiePlayerElytraLayer;
import net.smileycorp.hordes.client.render.ZombiePlayerModel;
import net.smileycorp.hordes.client.render.ZombiePlayerOverlayLayer;
import net.smileycorp.hordes.common.Constants;
import net.smileycorp.hordes.common.entities.PlayerZombie;
import net.smileycorp.hordes.config.ClientConfigHandler;

public class ZombiePlayerRenderer<T extends Zombie>
extends HumanoidMobRenderer<T, ZombiePlayerModel<T>> {
    public static final ModelLayerLocation DEFAULT = new ModelLayerLocation(Constants.loc("zombie_player"), "default");
    public static final ModelLayerLocation SLIM = new ModelLayerLocation(Constants.loc("zombie_player"), "slim");
    protected final ZombiePlayerModel<T> defaultModel;
    protected final ZombiePlayerModel<T> slimModel;
    private final boolean isTall;

    public ZombiePlayerRenderer(EntityRendererProvider.Context ctx, Color colour, ResourceLocation overlay, boolean isDrowned, boolean isTall) {
        super(ctx, new ZombiePlayerModel(ctx.bakeLayer(DEFAULT), colour, isDrowned), 0.5f);
        this.addLayer((RenderLayer)new HumanoidArmorLayer((RenderLayerParent)this, (HumanoidModel)new ZombieModel(ctx.bakeLayer(ModelLayers.ZOMBIE_INNER_ARMOR)), (HumanoidModel)new ZombieModel(ctx.bakeLayer(ModelLayers.ZOMBIE_OUTER_ARMOR)), ctx.getModelManager()));
        if (((Boolean)ClientConfigHandler.zombiePlayerCapes.get()).booleanValue()) {
            this.addLayer(new ZombiePlayerCapeLayer(this));
        }
        this.addLayer((RenderLayer)new ZombiePlayerElytraLayer(this, ctx.getModelSet()));
        this.addLayer(new ZombiePlayerOverlayLayer(this, new ZombiePlayerModel(ctx.bakeLayer(DEFAULT)), new ZombiePlayerModel(ctx.bakeLayer(SLIM)), overlay));
        this.defaultModel = (ZombiePlayerModel)this.model;
        this.slimModel = new ZombiePlayerModel(ctx.bakeLayer(SLIM), colour, isDrowned);
        this.isTall = isTall;
    }

    public ResourceLocation getTextureLocation(T entity) {
        Optional<UUID> optional = ((PlayerZombie)entity).getPlayerUUID();
        return PlayerTextureRenderer.getTexture(optional, (MinecraftProfileTexture.Type)MinecraftProfileTexture.Type.SKIN);
    }

    protected void scale(T entity, PoseStack poseStack, float p_114909_) {
        if (this.isTall) {
            poseStack.scale(1.0625f, 1.0625f, 1.0625f);
        }
        super.scale(entity, poseStack, p_114909_);
    }

    public void render(T entity, float yaw, float partialTicks, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        Optional<UUID> optional = ((PlayerZombie)entity).getPlayerUUID();
        boolean isSlim = "slim".equals(PlayerTextureRenderer.getSkinType(optional));
        if (isSlim && this.model != this.slimModel) {
            this.model = this.slimModel;
        } else if (!isSlim && this.model != this.defaultModel) {
            this.model = this.defaultModel;
        }
        super.render(entity, yaw, partialTicks, poseStack, bufferSource, packedLight);
    }

    public static LayerDefinition createLayer(boolean slim) {
        return LayerDefinition.create((MeshDefinition)ZombiePlayerModel.createMesh((CubeDeformation)CubeDeformation.NONE, (boolean)slim), (int)64, (int)64);
    }
}

