/*
 * Decompiled with CFR 0.152.
 */
package net.smileycorp.hordes.common;

import java.nio.file.Path;
import java.util.Optional;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.server.packs.PackLocationInfo;
import net.minecraft.server.packs.PackSelectionConfig;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.PathPackResources;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.monster.Drowned;
import net.minecraft.world.entity.monster.Husk;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.player.Player;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.fml.event.lifecycle.FMLConstructModEvent;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.fml.loading.FMLPaths;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.AddPackFindersEvent;
import net.neoforged.neoforge.event.entity.EntityAttributeCreationEvent;
import net.smileycorp.hordes.DataGenerator;
import net.smileycorp.hordes.client.ClientHandler;
import net.smileycorp.hordes.common.HordesLogger;
import net.smileycorp.hordes.common.MiscEventHandler;
import net.smileycorp.hordes.common.capability.HordesCapabilities;
import net.smileycorp.hordes.common.capability.ZombifyPlayer;
import net.smileycorp.hordes.common.entities.HordesEntities;
import net.smileycorp.hordes.config.ClientConfigHandler;
import net.smileycorp.hordes.config.CommonConfigHandler;
import net.smileycorp.hordes.config.HordeEventConfig;
import net.smileycorp.hordes.config.InfectionConfig;
import net.smileycorp.hordes.hordeevent.HordeEventHandler;
import net.smileycorp.hordes.hordeevent.capability.HordeSpawn;
import net.smileycorp.hordes.hordeevent.client.HordeClientHandler;
import net.smileycorp.hordes.hordeevent.data.DataRegistry;
import net.smileycorp.hordes.hordeevent.network.HordeEventPacketHandler;
import net.smileycorp.hordes.infection.HordesInfection;
import net.smileycorp.hordes.infection.InfectionEventHandler;
import net.smileycorp.hordes.infection.capability.Infection;
import net.smileycorp.hordes.infection.client.InfectionClientHandler;
import net.smileycorp.hordes.infection.network.InfectionPacketHandler;

@Mod(value="hordes")
public class Hordes {
    public Hordes(ModContainer container, IEventBus bus) {
        HordesLogger.clearLog();
        container.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)CommonConfigHandler.config);
        container.registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)ClientConfigHandler.config);
        HordesEntities.ENTITIES.register(bus);
        HordesInfection.ATTRIBUTES.register(bus);
        HordesInfection.EFFECTS.register(bus);
        if (DataGenerator.shouldGenerateFiles()) {
            if (FMLEnvironment.dist == Dist.CLIENT) {
                DataGenerator.generateAssets();
            }
            DataGenerator.generateData();
        } else {
            HordesLogger.logInfo("Config files are up to date, skipping data/asset generation");
        }
        bus.register((Object)this);
        bus.addListener(HordeEventPacketHandler::initPackets);
        bus.addListener(InfectionPacketHandler::initPackets);
        bus.addListener(InfectionEventHandler::addEntityAttributes);
        if (FMLEnvironment.dist == Dist.CLIENT) {
            bus.register((Object)new ClientHandler());
            bus.addListener(InfectionClientHandler.INSTANCE::registerOverlays);
        }
    }

    @SubscribeEvent
    public void constructMod(FMLConstructModEvent event) {
        NeoForge.EVENT_BUS.register((Object)new MiscEventHandler());
    }

    @SubscribeEvent
    public void commonSetup(FMLCommonSetupEvent event) {
        DataRegistry.init();
        if (((Boolean)HordeEventConfig.enableHordeEvent.get()).booleanValue()) {
            NeoForge.EVENT_BUS.register((Object)new HordeEventHandler());
        }
        if (((Boolean)InfectionConfig.enableMobInfection.get()).booleanValue()) {
            NeoForge.EVENT_BUS.register((Object)new InfectionEventHandler());
        }
    }

    @SubscribeEvent
    public void loadClient(FMLClientSetupEvent event) {
        NeoForge.EVENT_BUS.addListener(ClientHandler::renderNameplate);
        NeoForge.EVENT_BUS.register((Object)HordeClientHandler.INSTANCE);
        NeoForge.EVENT_BUS.register((Object)InfectionClientHandler.INSTANCE);
    }

    @SubscribeEvent
    public void attachCapabilities(RegisterCapabilitiesEvent event) {
        event.registerEntity(HordesCapabilities.ZOMBIFY_PLAYER, EntityType.PLAYER, (entity, ctx) -> new ZombifyPlayer.Impl((Player)entity));
        for (EntityType type : BuiltInRegistries.ENTITY_TYPE) {
            event.registerEntity(HordesCapabilities.HORDESPAWN, type, (entity, ctx) -> entity instanceof Mob ? new HordeSpawn.Impl() : null);
            event.registerEntity(HordesCapabilities.INFECTION, type, (entity, ctx) -> entity instanceof LivingEntity ? new Infection.Impl() : null);
        }
    }

    @SubscribeEvent
    public void registerAttributes(EntityAttributeCreationEvent event) {
        event.put((EntityType)HordesEntities.ZOMBIE_PLAYER.get(), Zombie.createAttributes().build());
        event.put((EntityType)HordesEntities.DROWNED_PLAYER.get(), Drowned.createAttributes().build());
        event.put((EntityType)HordesEntities.HUSK_PLAYER.get(), Husk.createAttributes().build());
    }

    @SubscribeEvent
    public void addPackFinders(AddPackFindersEvent event) {
        Path path = FMLPaths.CONFIGDIR.get().resolve("hordes");
        event.addRepositorySource(consumer -> consumer.accept(Pack.readMetaAndCreate((PackLocationInfo)new PackLocationInfo(path.toString(), (Component)Component.literal((String)"Hordes Config"), PackSource.BUILT_IN, Optional.empty()), (Pack.ResourcesSupplier)new PathPackResources.PathResourcesSupplier(path), (PackType)event.getPackType(), (PackSelectionConfig)new PackSelectionConfig(true, Pack.Position.TOP, false))));
    }
}

