/*
 * Decompiled with CFR 0.152.
 */
package net.smileycorp.hordes.common.ai;

import java.util.EnumSet;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.smileycorp.atlas.api.util.VecMath;

public class FleeEntityGoal
extends Goal {
    protected final Mob entity;
    protected final Level level;
    protected final PathNavigation pather;
    protected int timeToRecalcPath = 0;
    protected float waterCost;
    protected final double speed;
    protected final double range;
    protected final Predicate<LivingEntity> predicate;

    public FleeEntityGoal(Mob entity, double speed, double range, Predicate<LivingEntity> predicate) {
        this.entity = entity;
        this.level = entity.level();
        this.pather = entity.getNavigation();
        this.predicate = predicate;
        this.speed = speed;
        this.range = range;
        this.setFlags(EnumSet.of(Goal.Flag.LOOK, Goal.Flag.MOVE));
    }

    public boolean canUse() {
        return !this.getEntities().isEmpty();
    }

    private List<LivingEntity> getEntities() {
        return this.level.getEntitiesOfClass(LivingEntity.class, new AABB(this.entity.getX() - this.range, this.entity.getY() - this.range, this.entity.getZ() - this.range, this.entity.getX() + this.range, this.entity.getZ() + this.range, this.entity.getZ() + this.range), this.predicate);
    }

    public void start() {
        this.waterCost = this.entity.getPathfindingMalus(PathType.WATER);
    }

    public boolean canContinueToUse() {
        return true;
    }

    public void stop() {
        this.pather.stop();
        this.entity.setPathfindingMalus(PathType.WATER, this.waterCost);
    }

    public void tick() {
        if (this.timeToRecalcPath-- > 0) {
            return;
        }
        this.timeToRecalcPath = 5;
        this.pather.moveTo(this.pather.createPath(this.findSafePos(), 1), this.speed);
    }

    private Stream<BlockPos> findSafePos() {
        Vec3 pos = this.entity.position();
        Vec3 resultDir = new Vec3(0.0, 0.0, 0.0);
        for (LivingEntity entity : this.getEntities()) {
            Vec3 dir = VecMath.directionXZ((Entity)this.entity, (Entity)entity);
            resultDir = new Vec3((dir.x + resultDir.x) * 0.5, (dir.y + resultDir.y) * 0.5, (dir.z + resultDir.z) * 0.5);
        }
        return Stream.of(this.level.getHeightmapPos(Heightmap.Types.WORLD_SURFACE, BlockPos.containing((Position)pos.add(resultDir.reverse().multiply(5.0, 0.0, 5.0)))));
    }
}

