/*
 * Decompiled with CFR 0.152.
 */
package net.smileycorp.hordes.common.entities;

import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.biome.Biome;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.smileycorp.hordes.common.Constants;
import net.smileycorp.hordes.common.entities.DrownedPlayer;
import net.smileycorp.hordes.common.entities.HuskPlayer;
import net.smileycorp.hordes.common.entities.ZombiePlayer;

public class HordesEntities {
    public static final DeferredRegister<EntityType<?>> ENTITIES = DeferredRegister.create((Registry)BuiltInRegistries.ENTITY_TYPE, (String)"hordes");
    public static final TagKey<Biome> HUSK_PLAYER_SPAWN_BIOMES = TagKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)Constants.loc("husk_player_spawn_biomes"));
    public static final DeferredHolder<EntityType<?>, EntityType<ZombiePlayer>> ZOMBIE_PLAYER = HordesEntities.zombiePlayer("zombie_player", ZombiePlayer::new);
    public static final DeferredHolder<EntityType<?>, EntityType<HuskPlayer>> HUSK_PLAYER = HordesEntities.zombiePlayer("husk_player", HuskPlayer::new);
    public static final DeferredHolder<EntityType<?>, EntityType<DrownedPlayer>> DROWNED_PLAYER = HordesEntities.zombiePlayer("drowned_player", DrownedPlayer::new);

    private static <T extends Entity> DeferredHolder<EntityType<?>, EntityType<T>> zombiePlayer(String name, EntityType.EntityFactory<T> factory) {
        return ENTITIES.register(name, () -> EntityType.Builder.of((EntityType.EntityFactory)factory, (MobCategory)MobCategory.MONSTER).sized(0.6f, 1.95f).clientTrackingRange(8).build(name));
    }
}

