/*
 * Decompiled with CFR 0.152.
 */
package net.smileycorp.hordes.hordeevent;

import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Either;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.smileycorp.hordes.common.HordesLogger;
import net.smileycorp.hordes.hordeevent.HordeSpawnType;

public class CustomSpawnType
implements HordeSpawnType {
    private final List<Either<TagKey<Block>, Block>> blocks = Lists.newArrayList();

    public CustomSpawnType(List<String> strings) {
        for (String str : strings) {
            try {
                this.blocks.add((Either<TagKey<Block>, Block>)(str.contains("#") ? Either.left((Object)TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.tryParse((String)str.replace("#", "")))) : Either.right((Object)((Block)BuiltInRegistries.BLOCK.get(ResourceLocation.tryParse((String)str))))));
            }
            catch (Exception e) {
                HordesLogger.logError("Failed parsing block " + str, e);
            }
        }
    }

    @Override
    public boolean canSpawn(ServerLevel level, BlockPos pos) {
        BlockState state = level.getBlockState(pos.below());
        for (Either<TagKey<Block>, Block> either : this.blocks) {
            if (!((Boolean)either.map(arg_0 -> ((BlockState)state).is(arg_0), arg_0 -> ((BlockState)state).is(arg_0))).booleanValue()) continue;
            return true;
        }
        return false;
    }

    public ListTag toNbt() {
        ListTag tag = new ListTag();
        this.blocks.forEach(either -> tag.add((Object)StringTag.valueOf((String)((String)either.map(t -> "#" + String.valueOf(t.location()), b -> BuiltInRegistries.BLOCK.getKey(b).toString())))));
        return tag;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(this.getClass().getSimpleName() + "[");
        this.blocks.forEach(either -> builder.append((String)either.map(t -> "#" + String.valueOf(t.location()), b -> BuiltInRegistries.BLOCK.getKey(b).toString()) + ", "));
        return builder.append("]").toString();
    }
}

